/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;

public class CommandNationBroadcast
extends KingdomsCommand {
    public CommandNationBroadcast(KingdomsParentCommand parent) {
        super("broadcast", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasKingdom()) {
            KingdomsLang.NO_KINGDOM_DEFAULT.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        Kingdom kingdom = kp.getKingdom();
        if (!kingdom.hasNation()) {
            KingdomsLang.NO_NATION.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        if (!kp.hasNationPermission(StandardKingdomPermission.BROADCAST)) {
            StandardKingdomPermission.BROADCAST.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        Nation nation = kingdom.getNation();
        String message = context.joinArgs();
        MessagePlaceholderProvider settings = new MessagePlaceholderProvider().withContext(nation).parse("message", message).withContext(player);
        @NonNull List<Player> members = nation.getOnlineMembers();
        Bukkit.getOnlinePlayers().stream().filter(x -> KingdomPlayer.getKingdomPlayer((OfflinePlayer)x).isSpy()).forEach(members::add);
        for (Player member : members) {
            KingdomsLang.COMMAND_BROADCAST_FORMAT.sendMessage((CommandSender)member, settings);
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public @Nullable @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        if (context.isAtArg(0)) {
            return Collections.singletonList("<message>");
        }
        return new ArrayList<String>();
    }
}

