/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.visualizer;

import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.managers.land.indicator.LandVisualizer;

public class CommandVisualizeToggle
extends KingdomsCommand {
    public CommandVisualizeToggle(KingdomsParentCommand parent) {
        super("toggle", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        KingdomPlayer kp;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        boolean using = (kp = context.getKingdomPlayer()).isUsingMarkers();
        kp.setUsingMarkers(!using);
        if (using) {
            context.sendMessage((Messenger)KingdomsLang.COMMAND_VISUALIZE_TOGGLE_DISABLED, new Object[0]);
            LandVisualizer.removeVisualizers(player, true);
        } else {
            context.sendMessage((Messenger)KingdomsLang.COMMAND_VISUALIZE_TOGGLE_ENABLED, new Object[0]);
            new LandVisualizer().forPlayer(player, kp).forLand(Land.getLand(player.getLocation()), player.getLocation().getChunk()).display(true);
        }
        return CommandResult.SUCCESS;
    }
}

