/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.visualizer;

import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.land.indicator.LandVisualizer;

public class CommandVisualizePermanent
extends KingdomsCommand {
    public CommandVisualizePermanent(KingdomsParentCommand parent) {
        super("permanent", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        if (LandVisualizer.getPermanent().remove(player.getUniqueId())) {
            KingdomsLang.COMMAND_VISUALIZE_PERMANENT_DISABLED.sendMessage((CommandSender)player);
            LandVisualizer.removeVisualizers(player, true);
            return CommandResult.FAILED;
        }
        KingdomsLang.COMMAND_VISUALIZE_PERMANENT_ENABLED.sendMessage((CommandSender)player);
        LandVisualizer.getPermanent().add(player.getUniqueId());
        new LandVisualizer().forPlayer(player, KingdomPlayer.getKingdomPlayer((OfflinePlayer)player)).forLand(Land.getLand(player.getLocation()), player.getLocation().getChunk()).display(true);
        return CommandResult.SUCCESS;
    }
}

