/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.text;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.KLogger;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.internal.numbers.AnyNumber;
import org.kingdoms.utils.internal.numbers.Numbers;
import org.kingdoms.utils.internal.string.NumberMatcher;
import org.kingdoms.utils.string.Strings;

public class CommandTag
extends KingdomsCommand {
    public CommandTag() {
        super("tag", true);
    }

    public static String getTag(Group group) {
        if (group.getTag() != null) {
            return group.getTag();
        }
        ConfigSection automatic = KingdomsConfig.TAGS_ATTEMPT_AUTOMATIC_SETTING.getManager().getSection().getSection();
        for (String key : automatic.getKeys()) {
            String count;
            NumberMatcher matcher;
            Pattern pattern;
            ConfigSection test = automatic.getSection(key);
            String regexStr = test.getString("regex");
            if (Strings.isNullOrEmpty(regexStr)) {
                KLogger.error("Kingdom tag automatic RegEx is not set for: " + key);
                continue;
            }
            try {
                pattern = Pattern.compile(regexStr);
            }
            catch (PatternSyntaxException ex) {
                KLogger.error("Kingdom tag automatic RegEx is invalid: " + key + " -> '" + regexStr + "' " + ex.getMessage());
                continue;
            }
            String filtered = Strings.filterRegex(pattern, group.getName());
            Matcher matcher1 = pattern.matcher(filtered);
            boolean b = matcher1.find();
            if (filtered.isEmpty() || test.isSet("count") && !(matcher = NumberMatcher.parse(count = test.getString("count"))).matches(AnyNumber.of(filtered.length()))) continue;
            return filtered;
        }
        return group.getName();
    }

    public static boolean checkTag(String name, Player player) {
        int len;
        int max = KingdomsConfig.TAGS_MAX_LENGTH.getInt();
        int min = KingdomsConfig.TAGS_MIN_LENGTH.getInt();
        int n = len = KingdomsConfig.TAGS_IGNORE_COLORS.getBoolean() ? MessageHandler.stripColors(MessageHandler.colorize(name), false).length() : name.length();
        if (len < min || len > max) {
            KingdomsLang.COMMAND_TAG_NAME_LENGTH.sendMessage((CommandSender)player, "max", max, "min", min);
            return false;
        }
        if (!KingdomsConfig.TAGS_ALLOW_NUMBERS.getBoolean() && Numbers.containsAnyLangNumber(name)) {
            KingdomsLang.COMMAND_TAG_NAME_NUMBERS.sendMessage((CommandSender)player);
            return false;
        }
        if (!KingdomsConfig.TAGS_ALLOW_NON_ENGLISH.getBoolean() && !Strings.isEnglish(name)) {
            KingdomsLang.COMMAND_TAG_NAME_ENGLISH.sendMessage((CommandSender)player);
            return false;
        }
        if (!KingdomsConfig.TAGS_ALLOW_SYMBOLS.getBoolean() && Strings.hasSymbol(name)) {
            KingdomsLang.COMMAND_TAG_NAME_HAS_SYMBOLS.sendMessage((CommandSender)player);
            return false;
        }
        boolean match = false;
        String smallName = name.toLowerCase();
        for (String regex : KingdomsConfig.TAGS_BLACKLISTED_NAMES.getStringList()) {
            if (!Pattern.compile(regex).matcher(smallName).find()) continue;
            match = true;
            break;
        }
        if (match) {
            KingdomsLang.KINGDOM_TAG_BLACKLISTED.sendMessage((CommandSender)player, "tag", name);
            return false;
        }
        return true;
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasPermission(StandardKingdomPermission.LORE)) {
            StandardKingdomPermission.LORE.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        String name = Strings.buildArguments(context.args, KingdomsConfig.TAGS_ALLOW_SPACES.getBoolean() ? " " : "");
        Kingdom kingdom = kp.getKingdom();
        if (!context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_TAG_BYPASS_COST)) {
            if (!CommandTag.checkTag(name, player)) {
                return CommandResult.FAILED;
            }
            double cost = KingdomsConfig.ECONOMY_COSTS_TAG_KINGDOM.getDouble();
            if (!kingdom.getBank().has(cost)) {
                KingdomsLang.COMMAND_TAG_COST.sendMessage((CommandSender)player, "cost", cost);
                return CommandResult.FAILED;
            }
            kingdom.getBank().add(-cost);
        }
        String previousTag = kingdom.getTag();
        if (kingdom.renameTag(name, kp).isCancelled()) {
            return CommandResult.FAILED;
        }
        MessagePlaceholderProvider settings = new MessagePlaceholderProvider().parse("tag", previousTag == null ? KingdomsLang.NONE : previousTag).withContext(player);
        KingdomsLang msg = previousTag == null ? KingdomsLang.COMMAND_TAG_SET : KingdomsLang.COMMAND_TAG_CHANGED;
        for (Player member : kingdom.getOnlineMembers()) {
            msg.sendMessage((CommandSender)member, settings);
        }
        return CommandResult.SUCCESS;
    }
}

