/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageCompilerSettings;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.managers.land.indicator.LandVisualizer;
import org.kingdoms.utils.string.Strings;

public class CommandLore
extends KingdomsCommand {
    public CommandLore() {
        super("lore", true);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        Kingdom kingdom;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        String[] args = context.args;
        CommandSender sender = context.getMessageReceiver();
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasPermission(StandardKingdomPermission.LORE)) {
            StandardKingdomPermission.LORE.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        if (context.isAtArg(0) && KingdomsConfig.KINGDOM_LORE_REMOVE_KEYWORDS.getStringList().contains(args[0])) {
            Kingdom kingdom2 = kp.getKingdom();
            if (kingdom2.setLore(null, kp).isCancelled()) {
                return CommandResult.FAILED;
            }
            KingdomsLang.COMMAND_LORE_REMOVED.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        String lore = context.joinArgs();
        if (!kp.isAdmin()) {
            int len;
            int limit = KingdomsConfig.KINGDOM_LORE_MAX_LENGTH.getInt();
            int n = len = KingdomsConfig.KINGDOM_LORE_IGNORE_COLORS.getBoolean() ? MessageHandler.stripColors(MessageHandler.colorize(lore), false).length() : lore.length();
            if (len > limit) {
                KingdomsLang.COMMAND_LORE_NAME_LENGTH.sendMessage(sender, "limit", limit, "length", len);
                return CommandResult.FAILED;
            }
            if (!KingdomsConfig.KINGDOM_LORE_ALLOW_NON_ENGLISH.getBoolean() && !Strings.isEnglish(lore)) {
                KingdomsLang.COMMAND_LORE_NAME_ENGLISH.sendMessage((CommandSender)player);
                return CommandResult.FAILED;
            }
            if (!KingdomsConfig.KINGDOM_LORE_ALLOW_SYMBOLS.getBoolean() && Strings.hasSymbol(lore)) {
                KingdomsLang.COMMAND_LORE_NAME_HAS_SYMBOLS.sendMessage((CommandSender)player);
                return CommandResult.FAILED;
            }
            boolean match = false;
            if (!match) {
                for (String regex : KingdomsConfig.KINGDOM_LORE_BLACKLISTED_NAMES.getStringList()) {
                    if (!Pattern.compile(regex).matcher(lore).find()) continue;
                    match = true;
                    break;
                }
            }
            if (match) {
                KingdomsLang.COMMAND_LORE_BLACKLISTED.sendMessage(sender);
                return CommandResult.FAILED;
            }
        }
        if (KingdomsConfig.KINGDOM_LORE_ALLOW_COLORS.getBoolean()) {
            MessageObject messageObjectBuilder = MessageCompiler.compile(lore, MessageCompilerSettings.none().colorize());
            lore = messageObjectBuilder.buildPlain(new MessagePlaceholderProvider());
        }
        if ((kingdom = kp.getKingdom()).setLore(lore, kp).isCancelled()) {
            return CommandResult.FAILED;
        }
        new LandVisualizer().forLand(SimpleChunkLocation.of(player.getLocation())).forPlayer(player, kp).forKingdom(kingdom).displayMessages();
        return CommandResult.SUCCESS;
    }

    @Override
    public @Nullable List<String> tabComplete(@NonNull CommandTabContext context) {
        List<String> keywords;
        if (context.isAtArg(0) && !(keywords = KingdomsConfig.KINGDOM_LORE_REMOVE_KEYWORDS.getStringList()).isEmpty()) {
            String keyword = keywords.get(0);
            if (context.args[0].isEmpty() || keyword.toLowerCase(Locale.ENGLISH).startsWith(context.args[0].toLowerCase(Locale.ENGLISH))) {
                return Collections.singletonList(keywords.get(0));
            }
        }
        return new ArrayList<String>();
    }
}

