/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.teleports;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.general.teleports.CommandTpa;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.managers.teleportation.TeleportRequest;
import org.kingdoms.managers.teleportation.TeleportTask;
import org.kingdoms.managers.teleportation.TpManager;

public class CommandTpaAccept
extends KingdomsCommand {
    public CommandTpaAccept() {
        super("tpaaccept", true);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        int timerSeconds = KingdomsConfig.TPA_TELEPORT_TIMER_SECONDS.getInt();
        context.var("timer", timerSeconds);
        TeleportRequest request = CommandTpaAccept.getRequest(context, false);
        if (request == null) {
            return CommandResult.FAILED;
        }
        Player teleporter = request.getTeleporter();
        context.sendMessage((Messenger)KingdomsLang.COMMAND_TPAACCEPT_TELEPORTING_TARGET, new Object[0]);
        context.sendMessage((CommandSender)teleporter, KingdomsLang.COMMAND_TPAACCEPT_TELEPORTING_TELEPORTER, new Object[0]);
        AtomicInteger atomicTimer = new AtomicInteger(timerSeconds);
        TeleportTask task = TeleportTask.timer(teleporter, timerSeconds, timer -> context.sendMessage((CommandSender)teleporter, KingdomsLang.TELEPORTS_TIMER, "timer", atomicTimer.getAndDecrement()), () -> {
            teleporter.teleport((Entity)context.senderAsPlayer());
            context.sendMessage((Messenger)KingdomsLang.COMMAND_TPAACCEPT_TELEPORTED_NOTIFICATION, new Object[0]);
            context.sendMessage((CommandSender)teleporter, KingdomsLang.TELEPORTS_TELEPORTED, new Object[0]);
        });
        task.onAnyMove(p -> {
            KingdomsLang.TELEPORTS_MOVED.sendError((CommandSender)teleporter, new Object[0]);
            context.sendError(KingdomsLang.COMMAND_TPAACCEPT_CANCELLED, new Object[0]);
            return true;
        });
        TpManager.put(task);
        return CommandResult.SUCCESS;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static TeleportRequest getRequest(CommandContext context, boolean reject) {
        OfflinePlayer offlineTeleporter;
        if (context.assertPlayer()) {
            return null;
        }
        if (context.assertHasKingdom()) {
            return null;
        }
        Player target = context.senderAsPlayer();
        Set<UUID> requests = CommandTpa.RECEIVED_REQUESTS.get(target.getUniqueId());
        if (requests == null || requests.isEmpty()) {
            context.sendError(KingdomsLang.COMMAND_TPA_NO_REQUESTS, new Object[0]);
            return null;
        }
        context.var("target", target.getName());
        if (requests.size() > 1) {
            if (!context.assertArgs(1)) {
                context.sendError(KingdomsLang.COMMAND_TPA_MULTIPLE_REQUESTS, new Object[0]);
                return null;
            }
            offlineTeleporter = context.getOfflinePlayer(0);
            if (!requests.contains(offlineTeleporter.getUniqueId())) {
                context.var("teleporter", offlineTeleporter.getName());
                context.sendError(KingdomsLang.COMMAND_TPA_PLAYER_DIDNT_REQUEST, new Object[0]);
                return null;
            }
        } else {
            offlineTeleporter = Bukkit.getOfflinePlayer((UUID)requests.iterator().next());
        }
        context.var("teleporter", offlineTeleporter.getName());
        Player teleporter = offlineTeleporter.getPlayer();
        if (!reject) {
            if (teleporter == null) {
                context.sendError(KingdomsLang.COMMAND_TPAACCEPT_REQUESTER_OFFLINE, new Object[0]);
                return null;
            }
        } else if (teleporter != null && TpManager.isTeleporting(teleporter)) {
            context.sendError(KingdomsLang.COMMAND_TPAACCEPT_ALREADY_TELEPORTING_TARGET, new Object[0]);
            context.sendMessage((CommandSender)teleporter, KingdomsLang.COMMAND_TPAACCEPT_ALREADY_TELEPORTING_TELEPORTER, new Object[0]);
            return null;
        }
        if (!CommandTpa.canRequest(KingdomPlayer.getKingdomPlayer((OfflinePlayer)teleporter).getKingdom(), context.getKingdom())) {
            context.sendError(KingdomsLang.COMMAND_TPAACCEPT_CHANGED_RELATION, new Object[0]);
            return null;
        }
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)teleporter)) {
            context.sendError(KingdomsLang.COMMAND_TPAACCEPT_DISABLED_WORLD_TELEPORTER, new Object[0]);
            KingdomsLang.COMMAND_TPAACCEPT_DISABLED_WORLD_TELEPORTER_NOTIFY.sendError((CommandSender)teleporter, context.getMessageContext());
            return null;
        }
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)target)) {
            context.sendError(KingdomsLang.COMMAND_TPAACCEPT_DISABLED_WORLD_TARGET, new Object[0]);
            return null;
        }
        TeleportRequest request = CommandTpa.SENT_REQUESTS.remove(teleporter.getUniqueId());
        requests.remove(teleporter.getUniqueId());
        if (requests.isEmpty()) {
            CommandTpa.RECEIVED_REQUESTS.remove(target.getUniqueId());
        }
        request.cancel();
        return request;
    }

    protected static List<String> getRequestedPlayers(CommandTabContext context) {
        if (!context.isAtArg(0)) {
            return CommandTpaAccept.emptyTab();
        }
        if (!context.isPlayer()) {
            return CommandTpaAccept.emptyTab();
        }
        Player player = context.senderAsPlayer();
        Set<UUID> requests = CommandTpa.RECEIVED_REQUESTS.get(player.getUniqueId());
        if (requests == null || requests.isEmpty()) {
            return CommandTpaAccept.emptyTab();
        }
        return requests.stream().map(x -> Bukkit.getOfflinePlayer((UUID)x).getName()).collect(Collectors.toList());
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        return CommandTpaAccept.getRequestedPlayers(context);
    }
}

