/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.teleports;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.upgradable.MiscUpgrade;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.invasions.Invasion;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.utils.LocationUtils;

public class CommandTeleport
extends KingdomsCommand {
    private static final Map<Integer, Integer> TELEPORTING = new HashMap<Integer, Integer>();

    public CommandTeleport() {
        super("teleport", true);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        final Player player = context.senderAsPlayer();
        if (TELEPORTING.containsKey(player.getEntityId())) {
            KingdomsLang.COMMAND_TELEPORT_ALREADY_TELEPORTING.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            KingdomsLang.NO_KINGDOM_DEFAULT.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        List<Land> lands = kingdom.getLandsUnderAttack();
        if (lands.isEmpty()) {
            KingdomsLang.COMMAND_TELEPORT_NOT_INVADING.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        final Land land = lands.get(0);
        int upgradeReducer = kingdom.getUpgradeLevel(MiscUpgrade.INVASION_TELEPORTATION) >= 0 ? (int)MiscUpgrade.INVASION_TELEPORTATION.getScaling(kingdom) : 0;
        final int timer = KingdomsConfig.Invasions.TELEPORTATION_TELEPORT_DELAY.getManager().getInt() - upgradeReducer;
        if (timer <= 0 || context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_TELEPORT_BYPASS_TIMER, true)) {
            Invasion invasion = land.getInvasions().values().iterator().next();
            player.teleport(invasion.getStartLocation());
            KingdomsLang.COMMAND_TELEPORT_TELEPORTED.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        int id = new BukkitRunnable(){
            int timed;
            {
                this.timed = timer;
            }

            public void run() {
                if (--this.timed <= 0) {
                    Iterator<Invasion> iter = land.getInvasions().values().iterator();
                    if (iter.hasNext()) {
                        Invasion invasion = iter.next();
                        player.teleport(invasion.getStartLocation());
                        KingdomsLang.COMMAND_TELEPORT_TELEPORTED.sendMessage((CommandSender)player);
                    }
                    TELEPORTING.remove(player.getEntityId());
                    this.cancel();
                } else {
                    KingdomsLang.COMMAND_TELEPORT_TELEPORTING.sendMessage((CommandSender)player, "countdown", this.timed);
                }
            }
        }.runTaskTimer((Plugin)plugin, 0L, 20L).getTaskId();
        TELEPORTING.put(player.getEntityId(), id);
        return CommandResult.SUCCESS;
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent event) {
        TELEPORTING.remove(event.getPlayer().getEntityId());
    }

    @EventHandler(ignoreCancelled=true)
    public void onInvasionTeleportation(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (!KingdomsConfig.Invasions.TELEPORTATION_SHOULD_NOT_BE_DAMAGED.getManager().getBoolean()) {
            return;
        }
        Integer task = TELEPORTING.remove(event.getEntity());
        if (task != null) {
            Bukkit.getScheduler().cancelTask(task.intValue());
            KingdomsLang.COMMAND_TELEPORT_CANCELLED.sendMessage((CommandSender)event.getEntity());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onInvasionMove(PlayerMoveEvent event) {
        if (!KingdomsConfig.Invasions.TELEPORTATION_SHOULD_NOT_MOVE.getManager().getBoolean()) {
            return;
        }
        if (!LocationUtils.hasMoved(event.getFrom(), event.getTo())) {
            return;
        }
        Integer task = TELEPORTING.remove(event.getPlayer().getEntityId());
        if (task != null) {
            Bukkit.getScheduler().cancelTask(task.intValue());
            KingdomsLang.COMMAND_TELEPORT_CANCELLED.sendMessage((CommandSender)event.getPlayer());
        }
    }
}

