/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.resourcepoints.transfer;

import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.resourcepoints.CommandResourcePoints;
import org.kingdoms.commands.general.resourcepoints.transfer.CommandResourcePointsTransferKingdom;
import org.kingdoms.commands.general.resourcepoints.transfer.CommandResourcePointsTransferNation;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.utils.internal.numbers.Numbers;

public class CommandResourcePointsTransfer
extends KingdomsParentCommand {
    public CommandResourcePointsTransfer(KingdomsParentCommand parent) {
        super("transfer", parent);
        if (this.isDisabled()) {
            return;
        }
        new CommandResourcePointsTransferKingdom(this);
        new CommandResourcePointsTransferNation(this);
    }

    public static final class ResourcePointsTransfer {
        protected long amount;

        protected CommandResult handleBasics(CommandContext context) {
            if (context.assertPlayer()) {
                return CommandResult.FAILED;
            }
            if (context.assertHasKingdom()) {
                return CommandResult.FAILED;
            }
            if (context.requireArgs(1)) {
                return CommandResult.FAILED;
            }
            Player player = context.senderAsPlayer();
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            Kingdom kingdom = kp.getKingdom();
            if (!kingdom.hasNation()) {
                context.sendError(KingdomsLang.NO_NATION, new Object[0]);
                return CommandResult.FAILED;
            }
            if (!kp.hasPermission(StandardKingdomPermission.WITHDRAW)) {
                StandardKingdomPermission.WITHDRAW.sendDeniedMessage(player);
                return CommandResult.FAILED;
            }
            Long amount = CommandResourcePoints.validateAmount(false, context, null, 0);
            if (amount == null) {
                return CommandResult.FAILED;
            }
            this.amount = amount;
            context.var("rp", Numbers.toFancyNumber(amount.longValue()));
            context.var("amount", Numbers.toFancyNumber(amount.longValue()));
            return CommandResult.SUCCESS;
        }
    }
}

