/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.resourcepoints;

import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.gui.InventoryInteractiveGUI;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.buildings.structures.NexusManager;

public class CommandResourcePointsConverter
extends KingdomsCommand {
    public CommandResourcePointsConverter(KingdomsParentCommand parent) {
        super("converter", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            context.sendError(KingdomsLang.NO_KINGDOM_DEFAULT, new Object[0]);
            return CommandResult.FAILED;
        }
        new NexusManager(kingdom, player).openRp(rp -> rp.push("back", () -> {
            ((InventoryInteractiveGUI)rp).returnItems();
            player.closeInventory();
        }, new Object[0]));
        return CommandResult.SUCCESS;
    }
}

