/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.resourcepoints;

import java.util.List;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.resourcepoints.CommandResourcePointsConverter;
import org.kingdoms.commands.general.resourcepoints.CommandResourcePointsDeposit;
import org.kingdoms.commands.general.resourcepoints.CommandResourcePointsWithdraw;
import org.kingdoms.commands.general.resourcepoints.transfer.CommandResourcePointsTransfer;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.internal.numbers.Numbers;

public class CommandResourcePoints
extends KingdomsParentCommand {
    public CommandResourcePoints() {
        super("resourcepoints", true);
        if (this.isDisabled()) {
            return;
        }
        new CommandResourcePointsConverter(this);
        new CommandResourcePointsTransfer(this);
        new CommandResourcePointsWithdraw(this);
        new CommandResourcePointsDeposit(this);
    }

    public static Long validateAmount(boolean needsBankServices, CommandContext context, KingdomsLang usage, int index) {
        long amount;
        if (needsBankServices && ServiceHandler.bankServiceNotAvailable(context.getMessageReceiver())) {
            return null;
        }
        if (!context.assertArgs(index + 1)) {
            if (usage != null) {
                context.sendError(usage, new Object[0]);
            }
            return null;
        }
        String amountStr = context.arg(index);
        try {
            amount = Long.parseLong(amountStr);
        }
        catch (NumberFormatException ignored) {
            context.sendError(KingdomsLang.INVALID_NUMBER, "arg", amountStr, "needed", "rp");
            return null;
        }
        if (amount == 0L) {
            context.sendError(KingdomsLang.COMMAND_RESOURCEPOINTS_ZERO, new Object[0]);
            return null;
        }
        if (amount < 0L) {
            context.sendError(KingdomsLang.COMMAND_RESOURCEPOINTS_NEGATIVE, new Object[0]);
            return null;
        }
        return amount;
    }

    protected static List<String> processTabComplete(CommandTabContext context, boolean buying) {
        if (context.isAtArg(0)) {
            if (context.arg(0).isEmpty()) {
                return CommandResourcePoints.tabComplete("<amount>");
            }
            try {
                double amount = Long.parseLong(context.arg(0));
                return CommandResourcePoints.tabComplete('$' + Numbers.toFancyNumber(amount *= (buying ? KingdomsConfig.ECONOMY_RESOURCE_POINTS_WORTH_BUY : KingdomsConfig.ECONOMY_RESOURCE_POINTS_WORTH_SELL).getDouble()));
            }
            catch (NumberFormatException ignored) {
                return CommandResourcePoints.tabComplete("invalid");
            }
        }
        return CommandResourcePoints.emptyTab();
    }
}

