/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.relation;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.general.relation.CommandEnemy;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.KingdomRelationshipRequest;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.general.GroupRelationshipChangeEvent;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Unit;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.locale.placeholders.target.PlaceholderTarget;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.conditions.ConditionChain;
import org.kingdoms.utils.kingdoms.RelationUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0007J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0011H\u0007\u00a8\u0006\u0012"}, d2={"Lorg/kingdoms/commands/general/relation/RelationalCommandProcessor;", "", "<init>", "()V", "execute", "Lorg/kingdoms/commands/CommandResult;", "relation", "Lorg/kingdoms/constants/group/model/relationships/KingdomRelation;", "context", "Lorg/kingdoms/commands/CommandContext;", "notification", "Lorg/kingdoms/locale/messenger/Messenger;", "senderNotification", "receiverNotification", "tabComplete", "", "", "Lorg/kingdoms/commands/CommandTabContext;", "core"})
public final class RelationalCommandProcessor {
    @NotNull
    public static final RelationalCommandProcessor INSTANCE = new RelationalCommandProcessor();

    private RelationalCommandProcessor() {
    }

    @JvmStatic
    @NotNull
    public static final CommandResult execute(@NotNull KingdomRelation relation, @NotNull CommandContext context, @NotNull Messenger notification) {
        Intrinsics.checkNotNullParameter((Object)((Object)relation), (String)"relation");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        return RelationalCommandProcessor.execute(relation, context, notification, notification);
    }

    @JvmStatic
    @NotNull
    public static final CommandResult execute(@NotNull KingdomRelation relation, @NotNull CommandContext context, @NotNull Messenger senderNotification, @NotNull Messenger receiverNotification) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)relation), (String)"relation");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)senderNotification, (String)"senderNotification");
        Intrinsics.checkNotNullParameter((Object)receiverNotification, (String)"receiverNotification");
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        context.var("relation", relation.getColor() + relation.getName().buildPlain(context.getMessageContext()));
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = context.getKingdomPlayer();
        Kingdom kingdom = kp.getKingdom();
        Intrinsics.checkNotNull((Object)kingdom);
        Kingdom kingdom2 = kingdom;
        StandardKingdomPermission standardKingdomPermission = relation.getPermission();
        Intrinsics.checkNotNull((Object)standardKingdomPermission);
        if (!kp.hasPermission(standardKingdomPermission)) {
            StandardKingdomPermission standardKingdomPermission2 = relation.getPermission();
            Intrinsics.checkNotNull((Object)standardKingdomPermission2);
            standardKingdomPermission2.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        int relations = kingdom2.countRelationships(relation);
        double maxRelations = MathUtils.eval(relation.getLimit(), (PlaceholderProvider)context.getMessageContext());
        context.var("max", maxRelations);
        if (maxRelations > 0.0 && (double)relations >= maxRelations) {
            String[] stringArray = new String[]{"limit"};
            CommandResult commandResult = context.fail(context.lang(stringArray));
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        Kingdom kingdom3 = context.getKingdom(0);
        if (kingdom3 == null) {
            return CommandResult.FAILED;
        }
        Kingdom to = kingdom3;
        context.getMessageContext().other(to);
        if (Intrinsics.areEqual((Object)kingdom2.getId(), (Object)to.getId())) {
            String[] stringArray = new String[]{"self"};
            CommandResult commandResult = context.fail(context.lang(stringArray));
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        if (kingdom2.getRelationWith(to) == relation) {
            String[] stringArray = new String[]{"already"};
            CommandResult commandResult = context.fail(context.lang(stringArray));
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        Object $this$execute_u24lambda_u240 = INSTANCE;
        boolean bl = false;
        KingdomRelationshipRequest kingdomRelationshipRequest = to.getRelationshipRequests().get(kingdom2.getId());
        KingdomRelationshipRequest other = kingdom2.getRelationshipRequests().get(to.getId());
        if (kingdomRelationshipRequest != null && other != null) {
            kingdom2.getRelationshipRequests().remove(to.getId());
            to.getRelationshipRequests().remove(kingdom2.getId());
        } else {
            KingdomRelationshipRequest kingdomRelationshipRequest2 = kingdomRelationshipRequest;
            if ((kingdomRelationshipRequest2 != null ? kingdomRelationshipRequest2.getRelation() : null) == relation) {
                String[] stringArray = new String[]{"already-requested"};
                CommandResult commandResult = context.fail(context.lang(stringArray));
                Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
                return commandResult;
            }
        }
        if ((object = relation.getConditions()) != null) {
            MessagePlaceholderProvider messagePlaceholderProvider = new MessagePlaceholderProvider().withContext(PlaceholderTarget.Companion.of(kingdom2)).other(PlaceholderTarget.Companion.of(to));
            Intrinsics.checkNotNullExpressionValue((Object)messagePlaceholderProvider, (String)"other(...)");
            $this$execute_u24lambda_u240 = (Messenger)ConditionChain.evaluate$default(object, messagePlaceholderProvider, false, 2, null);
            if ($this$execute_u24lambda_u240 != null) {
                Object object2 = $this$execute_u24lambda_u240;
                boolean bl2 = false;
                context.sendError((Messenger)object2, new Object[0]);
            }
        }
        if (relation != KingdomRelation.ENEMY) {
            KingdomRelationshipRequest request = kingdom2.getRelationshipRequests().get(to.getId());
            if (request != null) {
                if (request.getRelation() != relation) {
                    CommandResult commandResult = context.fail(KingdomsLang.RELATIONS_ANOTHER_REQUEST);
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
                    return commandResult;
                }
                if (RelationUtil.acceptRequest(player, kingdom2, to, relation, senderNotification, receiverNotification).isCancelled()) {
                    return CommandResult.FAILED;
                }
                return CommandResult.SUCCESS;
            }
            if (kingdom2.sendRelationshipRequest(kp, to, relation).isCancelled()) {
                return CommandResult.FAILED;
            }
            String[] stringArray = new String[]{"sender"};
            Messenger messenger = context.lang(stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)messenger, (String)"lang(...)");
            context.sendMessage(messenger, new Object[0]);
            context.getMessageContext().switchTargets();
            for (Player player2 : to.getOnlineMembers()) {
                String[] bl2 = new String[]{"receiver"};
                context.sendMessage((CommandSender)player2, context.lang(bl2), new Object[0]);
            }
            object = context.getMessageContext().switchTargets();
            Intrinsics.checkNotNull((Object)object);
        } else {
            Nation nation;
            if (kingdom2.isStrongerThan(to)) {
                CommandResult commandResult = context.fail(KingdomsLang.COMMAND_ENEMY_HIGHER_STRENGTH);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
                return commandResult;
            }
            long cost = (long)MathUtils.eval(relation.getCost(), (PlaceholderProvider)context.getMessageContext());
            context.var("cost", cost);
            if (cost > 0L && !kingdom2.getResourcePoints().has(cost)) {
                CommandResult commandResult = context.fail(KingdomsLang.COMMAND_ENEMY_COST);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
                return commandResult;
            }
            GroupRelationshipChangeEvent event = new GroupRelationshipChangeEvent(kp, kingdom2, to, relation);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return CommandResult.FAILED;
            }
            if (cost != 0L) {
                kingdom2.getResourcePoints().add(-cost);
            }
            Map<UUID, KingdomRelation> map = kingdom2.getRelations();
            Intrinsics.checkNotNullExpressionValue(map, (String)"getRelations(...)");
            Map<UUID, KingdomRelation> map2 = map;
            map2.put(to.getId(), relation);
            Map<UUID, KingdomRelation> map3 = to.getRelations();
            Intrinsics.checkNotNullExpressionValue(map3, (String)"getRelations(...)");
            Map<UUID, KingdomRelation> map4 = map3;
            map4.put(kingdom2.getId(), relation);
            kingdom2.getRelationshipRequests().remove(to.getId());
            to.getRelationshipRequests().remove(kingdom2.getId());
            for (Player member2 : kingdom2.getOnlineMembers()) {
                context.sendMessage((CommandSender)member2, KingdomsLang.COMMAND_ENEMY_ENEMIES_SENDER, new Object[0]);
            }
            for (Player member3 : to.getOnlineMembers()) {
                context.getMessageContext().switchTargets();
                context.sendMessage((CommandSender)member3, KingdomsLang.COMMAND_ENEMY_ENEMIES_RECEIVER, new Object[0]);
                context.getMessageContext().switchTargets();
            }
            KingdomRelation[] kingdomRelationArray = new KingdomRelation[]{KingdomRelation.ALLY};
            kingdom2.getKingdomsWithRelation(kingdomRelationArray).stream().filter(arg_0 -> RelationalCommandProcessor.execute$lambda$3(arg_0 -> RelationalCommandProcessor.execute$lambda$2(to, arg_0), arg_0)).forEach(arg_0 -> RelationalCommandProcessor.execute$lambda$5(arg_0 -> RelationalCommandProcessor.execute$lambda$4(kingdom2, to, arg_0), arg_0));
            String[] stringArray2 = new String[]{"enemy"};
            stringArray2 = new String[]{"national-automation"};
            if (KingdomsConfig.Relations.RELATIONS.getManager().getSection().getSection().getSection(stringArray).getBoolean(stringArray2) && (nation = to.getNation()) != null) {
                Messenger messenger = KingdomsLang.COMMAND_ENEMY_NATIONAL_AUTOMATION;
                MessagePlaceholderProvider messagePlaceholderProvider = new MessagePlaceholderProvider().withContext(kingdom2).other(to);
                Intrinsics.checkNotNullExpressionValue((Object)messagePlaceholderProvider, (String)"other(...)");
                context.sendMessage(messenger, messagePlaceholderProvider);
                for (Kingdom nationMember : nation.getKingdoms()) {
                    Map<UUID, KingdomRelation> map5 = kingdom2.getRelations();
                    Intrinsics.checkNotNullExpressionValue(map5, (String)"getRelations(...)");
                    Map<UUID, KingdomRelation> map6 = map5;
                    map6.put(nationMember.getId(), relation);
                    Map<UUID, KingdomRelation> map7 = nationMember.getRelations();
                    Intrinsics.checkNotNullExpressionValue(map7, (String)"getRelations(...)");
                    map6 = map7;
                    map6.put(kingdom2.getId(), relation);
                    kingdom2.getRelationshipRequests().remove(nationMember.getId());
                    nationMember.getRelationshipRequests().remove(kingdom2.getId());
                }
            }
        }
        return CommandResult.SUCCESS;
    }

    @JvmStatic
    @NotNull
    public static final List<String> tabComplete(@NotNull KingdomRelation relation, @NotNull CommandTabContext context) {
        KingdomPlayer kp;
        Kingdom kingdom;
        Intrinsics.checkNotNullParameter((Object)((Object)relation), (String)"relation");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isPlayer() && (kingdom = (kp = context.getKingdomPlayer()).getKingdom()) != null) {
            List<String> list = context.getKingdoms(0, arg_0 -> RelationalCommandProcessor.tabComplete$lambda$6(kingdom, relation, arg_0));
            Intrinsics.checkNotNullExpressionValue(list, (String)"getKingdoms(...)");
            return list;
        }
        return CollectionsKt.emptyList();
    }

    private static final boolean execute$lambda$2(Kingdom $to, Kingdom x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return x.getRelationWith($to) == KingdomRelation.ALLY;
    }

    private static final boolean execute$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit execute$lambda$4(Kingdom $kingdom, Kingdom $to, Kingdom x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        CommandEnemy.notify(x, $kingdom, $to);
        return Unit.INSTANCE;
    }

    private static final void execute$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean tabComplete$lambda$6(Kingdom $kingdom, KingdomRelation $relation, String otherKingdomName) {
        String string = otherKingdomName;
        Intrinsics.checkNotNull((Object)string);
        Kingdom otherKingdom = Kingdom.getKingdom(string);
        return !Intrinsics.areEqual((Object)$kingdom, (Object)otherKingdom) && $kingdom.getRelationWith(otherKingdom) != $relation;
    }
}

