/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.relation;

import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.KingdomRelationshipRequest;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.LanguageEntryMessenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.kingdoms.RelationUtil;
import org.kingdoms.utils.time.TimeFormatter;
import org.kingdoms.utils.time.TimeUtils;

public class CommandRelations
extends KingdomsCommand {
    public CommandRelations() {
        super("relations", true);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        Kingdom kingdom = context.getKingdom();
        Map<UUID, KingdomRelationshipRequest> requests = kingdom.getRelationshipRequests();
        if (requests.isEmpty()) {
            KingdomsLang.COMMAND_RELATIONS_NO_REQUESTS.sendError((CommandSender)player, new Object[0]);
            return CommandResult.FAILED;
        }
        CommandRelations.openRelationsGUI(player, kingdom);
        return CommandResult.SUCCESS;
    }

    public static InteractiveGUI openRelationsGUI(Player player, Kingdom kingdom) {
        InteractiveGUI gui = GUIAccessor.prepare(player, KingdomsGUI.KINGDOM$RELATION$REQUESTS);
        if (gui == null) {
            return null;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        gui.push("back", () -> ((Player)player).closeInventory(), new Object[0]);
        ReusableOptionHandler inviteOpt = gui.getReusableOption("request");
        for (Map.Entry<UUID, KingdomRelationshipRequest> requestEntry : kingdom.getRelationshipRequests().entrySet()) {
            KingdomRelationshipRequest request = requestEntry.getValue();
            OfflinePlayer sender = Bukkit.getOfflinePlayer((UUID)request.getSender());
            KingdomRelation relation = request.getRelation();
            boolean expired = !request.canAccept();
            boolean hasPermission = kp.hasPermission(relation.getPermission());
            UUID kingdomId = requestEntry.getKey();
            Kingdom requestedKingdom = Kingdom.getKingdom(requestEntry.getKey());
            boolean invalid = requestedKingdom == null;
            ReusableOptionHandler opt = inviteOpt.setEdits("expired", expired, "invalid", invalid, "sender", sender.getName(), "timestamp", TimeUtils.getDateAndTime(request.getTimestamp()), "hasPermission", hasPermission);
            opt.getMessageContext().raw("time-passed", TimeFormatter.of(System.currentTimeMillis() - request.getTimestamp())).raw("time-left-to-accpet", TimeFormatter.of(request.getTimeLeftToAccept()));
            relation.placeholders(opt.getMessageContext());
            ((ReusableOptionHandler)opt.on(ClickType.LEFT, context -> {
                if (!hasPermission) {
                    relation.getPermission().sendDeniedMessage(player);
                    return;
                }
                int relations = kingdom.countRelationships(relation);
                int maxRelations = (int)MathUtils.eval(relation.getLimit(), (PlaceholderProvider)context.getMessageContext());
                context.var("max", maxRelations);
                if (maxRelations > 0 && relations >= maxRelations) {
                    context.sendError(new LanguageEntryMessenger("COMMAND_" + relation.name() + "_LIMIT"), new Object[0]);
                    return;
                }
                if (!expired && !invalid) {
                    RelationUtil.acceptRequest(player, kingdom, requestedKingdom, relation, RelationUtil.getAcceptMsgOf(relation));
                }
                kingdom.getRelationshipRequests().remove(kingdomId);
                CommandRelations.openRelationsGUI(player, kingdom);
            })).on(ClickType.RIGHT, ctx -> {
                if (!hasPermission) {
                    relation.getPermission().sendDeniedMessage(player);
                    return;
                }
                if (!invalid) {
                    ctx.sendError(KingdomsLang.COMMAND_REJECTRELATION_REJECTED, new Object[0]);
                    for (Player member : requestedKingdom.getOnlineMembers()) {
                        KingdomsLang.COMMAND_REJECTRELATION_NOTIFICATION.sendError((CommandSender)member, new MessagePlaceholderProvider().withContext(player).parse("relation", relation.getColor() + relation.getName().buildPlain(ctx.getMessageContext())));
                    }
                }
                kingdom.getRelationshipRequests().remove(kingdomId);
                CommandRelations.openRelationsGUI(player, kingdom);
            }).pushHead(sender);
            if (inviteOpt.hasNext()) continue;
            break;
        }
        gui.push("decline-all", () -> {
            kingdom.getRelationshipRequests().clear();
            CommandRelations.openRelationsGUI(player, kingdom);
        }, new Object[0]);
        gui.open();
        return gui;
    }
}

