/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.ranking;

import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.general.KingdomKingChangeEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;

public class CommandKing
extends KingdomsCommand {
    public CommandKing() {
        super("king", true);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.getRank().isKing()) {
            KingdomsLang.COMMAND_KING_ONLY_KING.sendError((CommandSender)player, new Object[0]);
            return CommandResult.FAILED;
        }
        OfflinePlayer king = context.getOfflinePlayer(0);
        if (king == null) {
            return CommandResult.FAILED;
        }
        KingdomPlayer kingKp = KingdomPlayer.getKingdomPlayer(king);
        if (!kingKp.hasKingdom() || !kingKp.getKingdomId().equals(kp.getKingdomId())) {
            KingdomsLang.COMMAND_KING_NOT_IN_KINGDOM.sendError((CommandSender)player, "king", king.getName());
            return CommandResult.FAILED;
        }
        if (king.getUniqueId().equals(player.getUniqueId())) {
            KingdomsLang.COMMAND_KING_SELF.sendError((CommandSender)player, new Object[0]);
            return CommandResult.FAILED;
        }
        Kingdom kingdom = kp.getKingdom();
        if (kingdom.setKing(kingKp, KingdomKingChangeEvent.Reason.KINGS_DECISION).isCancelled()) {
            return CommandResult.FAILED;
        }
        Object[] edits = new Object[]{"player", player.getName(), "rank", kingKp.getRank().getName(), "king", king.getName()};
        if (KingdomsConfig.ANNOUNCEMENTS_KING.getBoolean()) {
            KingdomsLang.COMMAND_KING_SET.sendEveryoneMessage(edits);
        } else {
            for (Player member : kingdom.getOnlineMembers()) {
                KingdomsLang.COMMAND_KING_SET.sendMessage((CommandSender)member, edits);
            }
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        if (context instanceof Player) {
            Player player = (Player)context;
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            Kingdom kingdom = kp.getKingdom();
            if (kingdom == null) {
                return CommandKing.tabComplete(KingdomsLang.NO_KINGDOM_DEFAULT.parse(player, new Object[0]));
            }
            if (context.isAtArg(0)) {
                return TabCompleteManager.getKingdomPlayers(kingdom, context.args[0]);
            }
        }
        return CommandKing.emptyTab();
    }
}

