/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.ranking;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.general.ranks.PlayerRankChangeContext;
import org.kingdoms.events.general.ranks.PlayerRankChangeEvent;
import org.kingdoms.events.general.ranks.RankIdentifier;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;

public class CommandDemote
extends KingdomsCommand {
    public CommandDemote() {
        super("demote", true);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer demoterKp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!demoterKp.hasKingdom()) {
            KingdomsLang.NO_KINGDOM_DEFAULT.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        if (!demoterKp.hasPermission(StandardKingdomPermission.MANAGE_RANKS)) {
            StandardKingdomPermission.MANAGE_RANKS.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        OfflinePlayer promoting = context.getOfflinePlayer(0);
        if (promoting == null) {
            return CommandResult.FAILED;
        }
        KingdomPlayer demotingKp = KingdomPlayer.getKingdomPlayer(promoting);
        if (!demoterKp.isInSameKingdomAs(demotingKp)) {
            KingdomsLang.COMMAND_DEMOTE_NOT_IN_KINGDOM.sendError((CommandSender)player, "demoted", promoting.getName());
            return CommandResult.FAILED;
        }
        if (!demoterKp.getRank().isHigherThan(demotingKp.getRank())) {
            KingdomsLang.COMMAND_DEMOTE_CANT_DEMOTE.sendError((CommandSender)player, "demoted", promoting.getName());
            return CommandResult.FAILED;
        }
        Kingdom kingdom = demoterKp.getKingdom();
        if (kingdom.getRanks().isMemberRank(demotingKp.getRank())) {
            KingdomsLang.COMMAND_DEMOTE_MEMBER.sendError((CommandSender)player, new Object[0]);
            return CommandResult.FAILED;
        }
        @NonNull PlayerRankChangeEvent event = demotingKp.changeRank(new PlayerRankChangeContext(kingdom, RankIdentifier.demote()).byPlayer(demoterKp));
        if (event.isCancelled()) {
            return CommandResult.FAILED;
        }
        Rank rank = event.getRank();
        Object[] edits = new Object[]{"rank", rank.getColor() + rank.getName(), "demoted", promoting.getName()};
        for (Player member : kingdom.getOnlineMembers()) {
            KingdomsLang.COMMAND_DEMOTE_DEMOTED.sendMessage((CommandSender)member, (OfflinePlayer)player, edits);
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        if (context instanceof Player) {
            Player player = (Player)context;
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            Kingdom kingdom = kp.getKingdom();
            if (kingdom == null) {
                return Collections.singletonList(KingdomsLang.NO_KINGDOM_DEFAULT.parse(player, new Object[0]));
            }
            if (context.isAtArg(0)) {
                return TabCompleteManager.getKingdomPlayers(kingdom, context.args[0], p -> p != context);
            }
        }
        return new ArrayList<String>();
    }
}

