/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.others;

import java.util.List;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;

public class CommandVault
extends KingdomsCommand {
    public CommandVault() {
        super("vault", true);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        Kingdom kingdom;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.assertArgs(1)) {
            if (!context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_VAULT_OTHERS)) {
                context.sendError(KingdomsLang.COMMAND_VAULT_OTHERS_PERMISSION, new Object[0]);
                return CommandResult.FAILED;
            }
            kingdom = context.getKingdom();
            if (kingdom == null) {
                return CommandResult.FAILED;
            }
        } else {
            KingdomPlayer kp = context.getKingdomPlayer();
            kingdom = kp.getKingdom();
            if (kingdom == null) {
                context.sendError(KingdomsLang.NO_KINGDOM_DEFAULT, new Object[0]);
                return CommandResult.FAILED;
            }
        }
        Player player = context.senderAsPlayer();
        player.openInventory(kingdom.getNexusChest().getOriginal());
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0) && context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_VAULT_OTHERS, true)) {
            return context.getKingdoms(0);
        }
        return CommandVault.emptyTab();
    }
}

