/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.others;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.stats.GroupedStat;
import org.kingdoms.constants.stats.Stat;
import org.kingdoms.constants.stats.Statistics;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Unit;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.comparisons.ComparisonsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.HoverMessage;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.locale.provider.MessageProvider;
import org.kingdoms.utils.string.tree.DefaultStringTreeSettings;
import org.kingdoms.utils.string.tree.StringPathBuilder;
import org.kingdoms.utils.string.tree.TreeBuilder;
import org.kingdoms.utils.string.tree.TreeStyle;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JD\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2$\u0010\u000b\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u000f0\r0\fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/kingdoms/commands/general/others/CommandStatistics;", "Lorg/kingdoms/commands/KingdomsCommand;", "<init>", "()V", "entries", "", "levels", "", "Lorg/kingdoms/constants/namespace/Namespace;", "statistics", "Lorg/kingdoms/constants/stats/Statistics;", "list", "", "Lorg/kingdoms/data/Pair;", "", "Ljava/util/function/Function;", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "core"})
@SourceDebugExtension(value={"SMAP\nCommandStatistics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandStatistics.kt\norg/kingdoms/commands/general/others/CommandStatistics\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1557#2:68\n1628#2,3:69\n1053#2:72\n*S KotlinDebug\n*F\n+ 1 CommandStatistics.kt\norg/kingdoms/commands/general/others/CommandStatistics\n*L\n27#1:68\n27#1:69,3\n53#1:72\n*E\n"})
public final class CommandStatistics
extends KingdomsCommand {
    public CommandStatistics() {
        super("statistics", true);
    }

    /*
     * WARNING - void declaration
     */
    private final void entries(List<Namespace> levels, Statistics statistics, List<Pair<String, Function<String, String>>> list) {
        void $this$mapTo$iv$iv;
        Set<Map.Entry<Namespace, Stat>> set = statistics.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entry);
            Namespace namespace = (Namespace)entry.getKey();
            Stat value = (Stat)entry.getValue();
            List newLevels = CollectionsKt.plus((Collection)levels, (Object)namespace);
            if (value instanceof GroupedStat) {
                this.entries(newLevels, ((GroupedStat)value).getValue(), list);
                object = Unit.INSTANCE;
            } else {
                String keyName = CollectionsKt.joinToString$default((Iterable)newLevels, (CharSequence)"/", null, null, (int)0, null, CommandStatistics::entries$lambda$2$lambda$0, (int)30, null);
                Pair<String, Function<String, String>> pair = new Pair<String, Function<String, String>>(keyName, arg_0 -> CommandStatistics.entries$lambda$2$lambda$1(namespace, value, arg_0));
                object = list.add(pair);
            }
            collection.add(object);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        Kingdom kingdom = context.getKingdom();
        if (kingdom.getStatistics().isEmpty()) {
            CommandResult commandResult = context.fail(KingdomsLang.COMMAND_STATISTICS_NOTHING);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        List list = new ArrayList();
        List list2 = CollectionsKt.emptyList();
        Statistics statistics = kingdom.getStatistics();
        Intrinsics.checkNotNullExpressionValue((Object)statistics, (String)"getStatistics(...)");
        this.entries(list2, statistics, list);
        Iterable $this$sortedBy$iv = list;
        boolean $i$f$sortedBy = false;
        StringPathBuilder pathBuilder = new StringPathBuilder(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
            }
        }), null);
        TreeStyle style = DefaultStringTreeSettings.INSTANCE.generateTreeStyle(false, 10);
        Iterator<StringBuilder> iterator = new TreeBuilder(pathBuilder).parse(style).print().getLines().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<StringBuilder> iterator2 = iterator;
        while (iterator2.hasNext()) {
            StringBuilder line;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            context.sendMessage((Messenger)new StaticMessenger(new MessageProvider(MessageCompiler.compile(line.toString(), DefaultStringTreeSettings.COMPILER_SETTINGS))), new Object[0]);
        }
        return CommandResult.SUCCESS;
    }

    private static final CharSequence entries$lambda$2$lambda$0(Namespace it) {
        String string = it.asNormalizedString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asNormalizedString(...)");
        return string;
    }

    private static final String entries$lambda$2$lambda$1(Namespace $namespace, Stat $value, String x) {
        return new HoverMessage($namespace.asNormalizedString(), "{$s}" + $value.getValue(), "").toString();
    }
}

