/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.others;

import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;

public class CommandSneak
extends KingdomsCommand {
    public CommandSneak() {
        super("sneak", true);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        boolean pvp;
        KingdomPlayer kp;
        Player player;
        if (context.assertArgs(1)) {
            if (!context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_SNEAK_OTHERS, true)) {
                context.sendError(KingdomsLang.COMMAND_SNEAK_OTHERS_PERMISSION, new Object[0]);
                return CommandResult.FAILED;
            }
            player = context.getPlayer(0);
            if (player == null) {
                return CommandResult.FAILED;
            }
        } else {
            if (context.assertPlayer()) {
                return CommandResult.FAILED;
            }
            player = context.senderAsPlayer();
        }
        kp.setSneakMode(!(pvp = (kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player)).isInSneakMode()));
        context.sendMessage((Messenger)(pvp ? KingdomsLang.COMMAND_SNEAK_DISABLED : KingdomsLang.COMMAND_SNEAK_ENABLED), new Object[0]);
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0) && context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_SNEAK_OTHERS, true)) {
            return context.getPlayers(0);
        }
        return CommandSneak.emptyTab();
    }
}

