/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.others;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.builders.ContextualMessageObject;
import org.kingdoms.locale.compiler.builders.MessageObjectLinker;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.target.PlaceholderTarget;
import org.kingdoms.main.KLogger;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.internal.functional.Fn;

public class CommandShow
extends KingdomsCommand {
    private static final int RELATION_LIMIT = 30;

    public CommandShow() {
        super("show", true);
    }

    public static MessageObjectLinker showMembers(Kingdom kingdom, CommandSender viewer) {
        Language language = LanguageManager.localeOf(viewer);
        MessageObjectLinker membersBuilder = new MessageObjectLinker();
        List<KingdomPlayer> members = kingdom.getKingdomPlayers();
        members.sort(KingdomPlayer::compareTo);
        int limit = XReflection.supports((int)17) ? 30 : 10;
        int remaining = members.size() - limit;
        for (OfflinePlayer player : (OfflinePlayer[])members.stream().map(KingdomPlayer::getOfflinePlayer).toArray(OfflinePlayer[]::new)) {
            boolean isOnline;
            if (limit-- <= 0) {
                membersBuilder.add(KingdomsLang.COMMAND_SHOW_MEMBERS_ETC, new MessagePlaceholderProvider().withContext(kingdom).raw("remaining", remaining));
                break;
            }
            Player online = player.getPlayer();
            boolean bl = isOnline = online != null;
            if (isOnline && ServiceHandler.isVanished(online) && !KingdomsDefaultPluginPermission.COMMAND_SHOW_SEE_VANISHED.hasPermission(viewer, true)) {
                isOnline = false;
            }
            KingdomsLang memberStatus = isOnline ? KingdomsLang.COMMAND_SHOW_ONLINE_PREFIX : KingdomsLang.COMMAND_SHOW_OFFLINE_PREFIX;
            membersBuilder.add(memberStatus.getMessageObject(language), new MessagePlaceholderProvider().withContext(player));
            membersBuilder.add(" ");
        }
        return membersBuilder;
    }

    public static void show(CommandSender sender, Kingdom kingdom, @NonNull PlaceholderTarget placeholder, boolean admin, boolean self) {
        MessageObject kingBuilder;
        Language locale = LanguageManager.localeOf(sender);
        if (kingdom.hasOwner()) {
            OfflinePlayer king = Bukkit.getOfflinePlayer((UUID)kingdom.getKingId());
            KingdomsLang kingStatus = king.isOnline() ? KingdomsLang.COMMAND_SHOW_ONLINE_PREFIX : KingdomsLang.COMMAND_SHOW_OFFLINE_PREFIX;
            kingBuilder = new ContextualMessageObject(kingStatus.getMessageObject(locale), new MessagePlaceholderProvider().withContext(king));
        } else {
            kingBuilder = KingdomsLang.COMMAND_SHOW_NO_KING.getMessageObject(locale);
        }
        MessagePlaceholderProvider context = new MessagePlaceholderProvider().withContext(placeholder).lang(locale);
        MessageObjectLinker membersBuilder = CommandShow.showMembers(kingdom, sender);
        MessageObjectLinker allies = new MessageObjectLinker();
        MessageObjectLinker truces = new MessageObjectLinker();
        MessageObjectLinker enemies = new MessageObjectLinker();
        int ally = 0;
        int truce = 0;
        int enemy = 0;
        ArrayList<UUID> remove = new ArrayList<UUID>();
        for (Map.Entry<UUID, KingdomRelation> relation : kingdom.getRelations().entrySet()) {
            Kingdom otherKingdom = Kingdom.getKingdom(relation.getKey());
            if (otherKingdom == null) {
                remove.add(relation.getKey());
                KLogger.error("Unknown kingdom while mapping relations of kingdom " + kingdom.getName() + ": " + relation.getKey());
                continue;
            }
            KingdomRelation rel = relation.getValue();
            MessagePlaceholderProvider settings = new MessagePlaceholderProvider().withContext(otherKingdom).other(kingdom);
            MessageObject msg = KingdomsLang.COMMAND_SHOW_RELATION.getMessageObject(locale);
            switch (rel) {
                case ALLY: {
                    if (ally == 30) {
                        allies.add("...");
                    } else if (ally < 30) {
                        allies.add(msg, settings).add(" ");
                    }
                    ++ally;
                    break;
                }
                case TRUCE: {
                    if (truce == 30) {
                        truces.add("...");
                    } else if (truce < 30) {
                        truces.add(msg, settings).add(" ");
                    }
                    ++truce;
                    break;
                }
                case ENEMY: {
                    if (enemy == 30) {
                        enemies.add("...");
                    } else if (enemy < 30) {
                        enemies.add(msg, settings).add(" ");
                    }
                    ++enemy;
                }
            }
        }
        for (UUID id : remove) {
            kingdom.getRelations().remove(id);
        }
        context.raws("is_self", self, "king_status", kingBuilder, "members", membersBuilder, "truces", truces, "allies", allies, "enemies", enemies);
        if (sender instanceof Player) {
            context.other((Player)sender);
        }
        KingdomsLang lang = admin ? KingdomsLang.COMMAND_SHOW_MESSAGE_ADMIN : KingdomsLang.COMMAND_SHOW_MESSAGE;
        lang.sendMessage(sender, context);
        if (ally != 0) {
            KingdomsLang.COMMAND_SHOW_ALLIES.sendMessage(sender, new MessagePlaceholderProvider().raws("allies", allies));
        }
        if (truce != 0) {
            KingdomsLang.COMMAND_SHOW_TRUCES.sendMessage(sender, new MessagePlaceholderProvider().raws("truces", truces));
        }
        if (enemy != 0) {
            KingdomsLang.COMMAND_SHOW_ENEMIES.sendMessage(sender, new MessagePlaceholderProvider().raws("enemies", enemies));
        }
    }

    @Override
    public CommandResult execute(CommandContext context) {
        boolean isSelf;
        PlaceholderTarget placeholder;
        Kingdom kingdom;
        if (!context.isPlayer() && context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        boolean admin = context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_SHOW_ADMIN, true);
        if (context.argsLengthEquals(0)) {
            if (context.assertHasKingdom()) {
                return CommandResult.FAILED;
            }
            Player player = context.senderAsPlayer();
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            kingdom = kp.getKingdom();
            placeholder = PlaceholderTarget.of(player);
            admin = true;
            isSelf = true;
        } else {
            isSelf = false;
            kingdom = (Kingdom)context.generalSelector(false);
            if (kingdom == null) {
                return CommandResult.FAILED;
            }
            if (kingdom.hasOwner()) {
                placeholder = PlaceholderTarget.of(kingdom.getKing().getOfflinePlayer());
            } else {
                Optional anyMember = kingdom.getPlayerMembers().stream().findAny();
                placeholder = anyMember.map(PlaceholderTarget::of).orElseGet(() -> PlaceholderTarget.of(kingdom));
            }
        }
        if (!admin) {
            admin = kingdom.isMember((OfflinePlayer)context.senderAsPlayer());
        }
        if (!admin && !context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_SHOW_OTHERS)) {
            context.sendError(KingdomsLang.COMMAND_SHOW_OTHERS_PERMISSION, new Object[0]);
            return CommandResult.FAILED;
        }
        CommandShow.show(context.getMessageReceiver(), kingdom, placeholder, admin, isSelf);
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        return context.tabCompleteGeneralSelector(false, true, Fn.alwaysTrue()).build();
    }
}

