/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.others;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.members.KingdomKickEvent;
import org.kingdoms.events.members.LeaveReason;
import org.kingdoms.libs.caffeine.cache.Cache;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.libs.xseries.particles.XParticle;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.managers.daily.elections.Elections;
import org.kingdoms.managers.daily.elections.ElectionsManager;
import org.kingdoms.utils.cache.caffeine.CacheHandler;

public class CommandKick
extends KingdomsCommand {
    private static final Cache<UUID, Byte> EASTER_CACHE = CacheHandler.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).build();

    public CommandKick() {
        super("kick", true);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            MessageHandler.sendConsolePluginMessage("&2You can use &6/k admin kick <player> &2instead.");
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        OfflinePlayer kick = context.getOfflinePlayer(0);
        if (kick == null) {
            return CommandResult.FAILED;
        }
        CommandKick.kick(context.getKingdom(), context.senderAsPlayer(), kick, false);
        return CommandResult.SUCCESS;
    }

    public static void kick(Kingdom kingdom, Player kicker, OfflinePlayer kick, boolean orHasPermission) {
        Player onlineKicked;
        KingdomPlayer kickerKp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)kicker);
        KingdomPlayer kickedKp = KingdomPlayer.getKingdomPlayer(kick);
        if (!orHasPermission && !kickerKp.hasPermission(StandardKingdomPermission.KICK)) {
            StandardKingdomPermission.KICK.sendDeniedMessage(kicker);
            return;
        }
        if (kick.getUniqueId().equals(kicker.getUniqueId())) {
            if (EASTER_CACHE.getIfPresent((Object)kicker.getUniqueId()) == null) {
                KingdomsLang.COMMAND_KICK_SELF.sendError((CommandSender)kicker, new Object[0]);
                ParticleDisplay.of((XParticle)XParticle.CLOUD).withCount(100).offset(0.5).spawn(kicker.getLocation());
                Vector velocity = kicker.getLocation().getDirection().normalize().multiply(1.1);
                velocity.setY(-0.3);
                kicker.setVelocity(velocity);
                double hp = kicker.getHealth();
                if (hp >= 0.001) {
                    kicker.damage(1.0E-6);
                    kicker.setHealth(hp);
                }
                EASTER_CACHE.put((Object)kicker.getUniqueId(), (Object)0);
            } else {
                KingdomsLang.COMMAND_KICK_SELF_SECONDARY.sendError((CommandSender)kicker, new Object[0]);
            }
            return;
        }
        if (!kingdom.isMember(kick)) {
            KingdomsLang.COMMAND_KICK_NOT_IN_KINGDOM.sendError((CommandSender)kicker, "kicked", kick.getName());
            return;
        }
        if (Elections.KINGDOMS.isAcceptingVotes() && Elections.KINGDOMS.areKicksDisallowed() && ElectionsManager.isEnabledFor(kingdom)) {
            KingdomsLang.COMMAND_KICK_ELECTIONS.sendMessage((CommandSender)kicker);
            return;
        }
        KingdomKickEvent event = new KingdomKickEvent(kickedKp, false, (OfflinePlayer)kicker);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (kickedKp.hasKingdom()) {
            if (!kickerKp.getRank().isHigherThan(kickedKp.getRank())) {
                KingdomsLang.COMMAND_KICK_CANT_KICK.sendError((CommandSender)kicker, "kicked", kick.getName());
                return;
            }
            if (kick.isOnline()) {
                KingdomsLang.COMMAND_KICK_PERSON.sendMessage((CommandSender)kick.getPlayer(), "kingdom", kingdom.getName(), "kicker", kicker.getName());
            }
            kickedKp.leaveKingdom(LeaveReason.KICKED);
        } else {
            kingdom.unsafeGetMembers().remove(kickedKp.getId());
        }
        for (Player member : kingdom.getOnlineMembers()) {
            KingdomsLang.COMMAND_KICK_ANNOUNCE.sendMessage((CommandSender)member, "kicker", kicker.getName(), "kicked", kick.getName());
        }
        if (KingdomsConfig.TELEPORT_TO_SPAWN_AFTER_KICK.getManager().getBoolean() && (onlineKicked = kick.getPlayer()) != null) {
            onlineKicked.teleport(onlineKicked.getWorld().getSpawnLocation());
        }
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (!context.isPlayer()) {
            return CommandKick.emptyTab();
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)context.senderAsPlayer());
        Kingdom kingdom = kp.getKingdom();
        if (kingdom != null && context.isAtArg(0)) {
            return context.getKingdomPlayers(kingdom, context.arg(0), player -> !player.getUniqueId().equals(kp.getKingdomId()));
        }
        return CommandKick.emptyTab();
    }
}

