/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.others;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.gui.GUIBuilder;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.InventoryInteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.server.inventory.InventoryView;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.hash.EntityHashSet;
import org.kingdoms.utils.hash.EntityWeakHashSet;

public class CommandInventory
extends KingdomsCommand
implements Listener {
    private static final EntityWeakHashSet<HumanEntity> VIEWING = ((EntityHashSet.WeakBuilder)((EntityHashSet.WeakBuilder)EntityHashSet.weakBuilder(HumanEntity.class).onDeath(EntityHashSet::remove)).onLeave(EntityHashSet::remove)).build();

    public CommandInventory() {
        super("inventory");
    }

    public static InteractiveGUI invsee(Player viewer, Player target) {
        int i;
        EntityEquipment armor;
        ItemStack offhandItem;
        InventoryInteractiveGUI gui = (InventoryInteractiveGUI)new GUIBuilder(KingdomsGUI.INVSEE).forPlayer(viewer).withSettings(new MessagePlaceholderProvider().withContext(target).raw("target", target.getName()).raw("held_slot", target.getInventory().getHeldItemSlot() + 1)).inventoryGUIOnly().build();
        Inventory inventory = gui.getInventory();
        ConfigSection options = gui.getConfig();
        ItemStack mainHand = target.getInventory().getItemInMainHand();
        if (mainHand.getType() != Material.AIR) {
            gui.option("mainhand").editItem(item -> mainHand).done();
        }
        if ((offhandItem = target.getInventory().getItemInOffHand()).getType() != Material.AIR) {
            gui.option("offhand").editItem(item -> offhandItem).done();
        }
        if ((armor = target.getEquipment()).getHelmet() != null) {
            gui.option("helmet").editItem(item -> armor.getHelmet()).done();
        }
        if (armor.getChestplate() != null) {
            gui.option("chestplate").editItem(item -> armor.getChestplate()).done();
        }
        if (armor.getLeggings() != null) {
            gui.option("leggings").editItem(item -> armor.getLeggings()).done();
        }
        if (armor.getBoots() != null) {
            gui.option("boots").editItem(item -> armor.getBoots()).done();
        }
        gui.setRemainingOptions();
        int startSlot = 9 * (options.getInt("context-start-row") - 1);
        ItemStack[] items = target.getInventory().getStorageContents();
        for (i = 9; i < items.length; ++i) {
            inventory.setItem(startSlot++, items[i]);
        }
        for (i = 0; i < 9; ++i) {
            inventory.setItem(startSlot++, items[i]);
        }
        return gui;
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (!context.assertArgs(1)) {
            context.sendError(KingdomsLang.COMMAND_INVENTORY_USAGE, new Object[0]);
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = context.getKingdomPlayer();
        Kingdom kingdom = kp.getKingdom();
        boolean othersPermission = context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_INVENTORY_OTHERS);
        if (kingdom == null && !othersPermission) {
            context.sendError(KingdomsLang.NO_KINGDOM_DEFAULT, new Object[0]);
            return CommandResult.FAILED;
        }
        if (!othersPermission && !kp.hasPermission(StandardKingdomPermission.INVSEE)) {
            context.sendError(KingdomsLang.COMMAND_INVENTORY_PERMISSION, new Object[0]);
            return CommandResult.FAILED;
        }
        Player target = context.getPlayer(0);
        if (target == null) {
            return CommandResult.FAILED;
        }
        if (!othersPermission && !kingdom.isMember((OfflinePlayer)target)) {
            context.sendError(KingdomsLang.COMMAND_INVENTORY_NOT_IN_KINGDOM, "target", target.getName());
            return CommandResult.FAILED;
        }
        VIEWING.add((HumanEntity)player);
        CommandInventory.invsee(player, target).open(false, false);
        return CommandResult.SUCCESS;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onInventoryClick(InventoryClickEvent event) {
        if (VIEWING.contains(InventoryView.of(event.getView()).getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onInventoryDrag(InventoryDragEvent event) {
        if (VIEWING.contains(InventoryView.of(event.getView()).getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        if (event.getInventory().getType() != InventoryType.CHEST) {
            return;
        }
        VIEWING.remove(event.getPlayer());
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            if (context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_INVENTORY_OTHERS)) {
                return context.getPlayers(0);
            }
            KingdomPlayer kp = context.getKingdomPlayer();
            Kingdom kingdom = kp.getKingdom();
            if (kingdom == null) {
                return context.tabComplete(KingdomsLang.NO_KINGDOM_DEFAULT.parse(new Object[0]));
            }
            return context.getKingdomPlayers(kingdom, 0);
        }
        return context.emptyTab();
    }
}

