/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.others;

import java.util.List;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.objects.Extractor;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.utils.internal.numbers.Numbers;

public class CommandExtractor
extends KingdomsCommand {
    public CommandExtractor() {
        super("extractor");
    }

    @Override
    public CommandResult execute(CommandContext context) {
        Kingdom kingdom;
        KingdomPlayer kp;
        KingdomPlayer kingdomPlayer = kp = context.isPlayer() ? context.getKingdomPlayer() : null;
        if (context.assertArgs(1)) {
            if (!kp.isAdmin() && !context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_EXTRACTOR_OTHERS)) {
                context.sendMessage((Messenger)KingdomsLang.COMMAND_EXTRACTOR_COLLECT_OTHERS_PERMISSION, new Object[0]);
                return CommandResult.FAILED;
            }
            kingdom = context.getKingdom(0);
            if (kingdom == null) {
                return CommandResult.FAILED;
            }
        } else {
            kingdom = kp.getKingdom();
            if (kingdom == null) {
                context.sendError(KingdomsLang.NO_KINGDOM_DEFAULT, new Object[0]);
                return CommandResult.FAILED;
            }
        }
        int extractors = 0;
        long totalRp = 0L;
        for (Structure structure : kingdom.getAllStructures()) {
            if (!(structure instanceof Extractor)) continue;
            Extractor extractor = (Extractor)structure;
            totalRp += extractor.collect(kp);
            ++extractors;
        }
        context.sendMessage((Messenger)(context.assertArgs(1) ? KingdomsLang.COMMAND_EXTRACTOR_COLLECTED_OTHERS : KingdomsLang.COMMAND_EXTRACTOR_COLLECTED), "rp", Numbers.toFancyNumber(totalRp), "extractors", extractors, "kingdom", kingdom.getName());
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(1) && context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_EXTRACTOR_OTHERS)) {
            return context.getKingdoms(0);
        }
        return CommandExtractor.emptyTab();
    }
}

