/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.others;

import java.util.List;
import org.bukkit.permissions.PermissionDefault;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.top.common.GroupTopData;
import org.kingdoms.data.managers.GroupManager;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.builders.MessageObjectLinker;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.internal.numbers.Numbers;

public abstract class CommandAbstractTop<V extends Group>
extends KingdomsCommand {
    public CommandAbstractTop(KingdomsParentCommand parent) {
        super("top", parent, PermissionDefault.TRUE);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        context.sendMessage((Messenger)KingdomsLang.COMMAND_TOP_LOADING, new Object[0]);
        Kingdoms.taskScheduler().async().execute(() -> this.showTop(context));
        return CommandResult.SUCCESS;
    }

    protected abstract GroupManager<V> getGroupManager();

    protected abstract KingdomsConfig getTopAmountLimit();

    protected abstract Messenger getHeaderMessage();

    protected abstract Messenger getEntryMessage();

    protected abstract Messenger getFooterMessage();

    protected abstract Messenger getTypeSelectMessage();

    protected abstract Messenger getTypeSelectedMessage();

    private void showTop(CommandContext context) {
        GroupManager<V> manager = this.getGroupManager();
        if (manager.isInstantTopUpdate()) {
            manager.updateTop();
        }
        int page = 1;
        if (context.assertArgs(1)) {
            Integer tempPage = context.getInt(0);
            if (tempPage == null) {
                return;
            }
            page = tempPage;
        }
        int nextPage = page + 1;
        int previousPage = page - 1;
        context.var("page", page).var("next_page", nextPage).var("previous_page", previousPage);
        String topType = context.assertArgs(2) ? context.arg(1) : "default";
        context.var("top_type", topType);
        GroupTopData topData = manager.getTopData(topType);
        if (topData == null) {
            context.fail(KingdomsLang.COMMAND_TOP_UNKNOWN_TYPE);
            return;
        }
        context.var("top_displayname", topData.getDisplayName());
        if (page - 1 < 0) {
            context.fail(KingdomsLang.COMMAND_TOP_NEGATIVE);
            return;
        }
        int limit = this.getTopAmountLimit().getInt();
        int skip = (page - 1) * limit;
        List groups = topData.getTop(skip, limit, topData.getPredicate());
        if (groups.isEmpty()) {
            context.fail(KingdomsLang.COMMAND_TOP_NO_MORE_PAGES);
            return;
        }
        int finalPage = page;
        KLogger.debug((DebugNS)KingdomsDebug.COMMAND_TOP, () -> "Displaying top kingdoms with limit=" + limit + ", skip=" + skip + ", filter=" + topData.getFilter().asString(true) + ", page=" + finalPage + ", filtered=" + groups.size());
        context.sendMessage(this.getHeaderMessage(), new Object[0]);
        int ranking = skip == 0 ? 1 : skip;
        for (Group group : groups) {
            MessagePlaceholderProvider placeholderProvider = new MessagePlaceholderProvider().withContext(group).raws("rank", String.valueOf(ranking++), "page", page, "next_page", nextPage, "previous_page", previousPage, "top_value", Numbers.toFancyNumber(topData.getTopValueOf(group)));
            this.getEntryMessage().sendMessage(context.getMessageReceiver(), placeholderProvider);
        }
        MessageObjectLinker linker = new MessageObjectLinker();
        int size = manager.getTopData().size();
        for (GroupTopData<V> type : manager.getTopData().values()) {
            linker.add(type == topData ? this.getTypeSelectedMessage() : this.getTypeSelectMessage(), new MessagePlaceholderProvider().raws("top_displayname", type.getDisplayName(), "top_name", type.getDataName(), "top_description", type.getDescription()));
            if (--size <= 0) continue;
            linker.add(" {$sep}- ");
        }
        context.getMessageContext().raw("top_types", linker);
        context.sendMessage(this.getFooterMessage(), new Object[0]);
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        if (context.isAtArg(0)) {
            return context.tabComplete("[page]");
        }
        if (context.isAtArg(1)) {
            return context.tabComplete(this.getGroupManager().getTopData().keySet());
        }
        return context.emptyTab();
    }
}

