/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.nexus;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.nexus.CommandNexusOpen;
import org.kingdoms.commands.general.nexus.CommandNexusRemove;
import org.kingdoms.commands.nation.nexus.CommandNationNexus;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.general.KingdomDisbandEvent;
import org.kingdoms.events.lands.LandChangeEvent;
import org.kingdoms.events.lands.NexusMoveEvent;
import org.kingdoms.events.members.KingdomLeaveEvent;
import org.kingdoms.libs.xseries.XBlock;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.XTag;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.libs.xseries.particles.Particles;
import org.kingdoms.libs.xseries.particles.XParticle;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.PlayerUtils;

public class CommandNexus
extends KingdomsParentCommand
implements Listener {
    private static final Map<Player, UUID> SESSIONS = new HashMap<Player, UUID>();

    public CommandNexus() {
        super("nexus", true);
        new CommandNexusOpen(this);
        new CommandNexusRemove(this);
    }

    public static boolean isSettingNexus(Player player) {
        return SESSIONS.containsKey(player);
    }

    private static void actionBar(final Player player) {
        if (!KingdomsConfig.NEXUS_ACTIONBAR_ENABLED.getBoolean()) {
            return;
        }
        if (KingdomsConfig.NEXUS_ACTIONBAR_KEEP.getBoolean()) {
            new BukkitRunnable(){

                public void run() {
                    if (!SESSIONS.containsKey(player)) {
                        this.cancel();
                        return;
                    }
                    KingdomsLang.COMMAND_NEXUS_ACTIVATED.sendMessage((CommandSender)player);
                }
            }.runTaskTimer((Plugin)plugin, 0L, 40L);
        } else {
            KingdomsLang.COMMAND_NEXUS_ACTIVATED.sendMessage((CommandSender)player);
        }
    }

    public static Block predicateNexusBlock(Player player, Block target, BlockFace facing, boolean replacing, boolean interact) {
        XMaterial base;
        boolean contains;
        if (!replacing) {
            target = target.getRelative(facing);
            if (!interact && !target.getType().name().endsWith("AIR")) {
                return null;
            }
        }
        if ((contains = XTag.anyMatch((Object)(base = XMaterial.matchXMaterial((Material)target.getType())), (Collection)XTag.stringMatcher(KingdomsConfig.NEXUS_REPLACE_BLOCKS_LIST.getStringList(), null))) == KingdomsConfig.NEXUS_REPLACE_BLOCKS_BLACKLIST.getBoolean()) {
            return null;
        }
        return target;
    }

    public static void preview(final Player player, final Kingdom kingdom, final boolean national, final Supplier<Boolean> whileTrue) {
        if (!KingdomsConfig.NEXUS_PREVIEW_ENABLED.getBoolean()) {
            return;
        }
        final boolean replace = KingdomsConfig.NEXUS_REPLACE_RIGHT_CLICK.getBoolean();
        long refresh = KingdomsConfig.NEXUS_PREVIEW_REFRESH_TICKS.getInt();
        long flick = KingdomsConfig.NEXUS_PREVIEW_FLICK_TICKS.getInt();
        final long diff = refresh - flick;
        final XMaterial errorMaterial = XMaterial.matchXMaterial((String)KingdomsConfig.NEXUS_PREVIEW_OUT_OF_LAND_BLOCK.getString()).orElse(XMaterial.REDSTONE_BLOCK);
        new BukkitRunnable(){

            public void run() {
                if (!((Boolean)whileTrue.get()).booleanValue()) {
                    this.cancel();
                    return;
                }
                List lastBlocks = player.getLastTwoTargetBlocks(null, 5);
                if (lastBlocks.size() < 2) {
                    return;
                }
                Block looking = (Block)lastBlocks.get(lastBlocks.size() - 1);
                if (XBlock.isAir((Material)looking.getType())) {
                    return;
                }
                BlockFace face = ((Block)lastBlocks.get(1)).getFace((Block)lastBlocks.get(0));
                if ((looking = CommandNexus.predicateNexusBlock(player, looking, face, replace, false)) == null) {
                    return;
                }
                if (player.getLocation().distanceSquared(looking.getLocation()) <= 1.0 || player.getEyeLocation().distanceSquared(looking.getLocation()) <= 1.0) {
                    return;
                }
                Land land = Land.getLand(looking);
                XMaterial previewMaterial = XMaterial.BEACON;
                if (land != null && land.isClaimed() && (national ? kingdom.getNationId().equals(land.getKingdom().getNationId()) : kingdom.isClaimed(land.getLocation()))) {
                    Structure structure = land.getStructure(struct -> {
                        StructureType type = (StructureType)((StructureStyle)struct.getStyle()).getType();
                        return type.isNexus() && national != type.isNationalNexus();
                    });
                    if (structure != null) {
                        previewMaterial = errorMaterial;
                    }
                } else {
                    previewMaterial = errorMaterial;
                }
                PlayerUtils.sendBlockChange(player, looking.getLocation(), previewMaterial);
                Block finalLook = looking;
                Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)plugin, () -> PlayerUtils.sendBlockChange(player, finalLook), diff);
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, 0L, refresh);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        Land land;
        SimpleLocation nexus;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)player, KingdomsLang.DISABLED_WORLD)) {
            context.sendError(KingdomsLang.COMMAND_NEXUS_DISABLED_WORLD, new Object[0]);
            return CommandResult.FAILED;
        }
        if (CommandNationNexus.isSettingNexus(player)) {
            KingdomsLang.COMMAND_NEXUS_SETTING_NATION.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        if (SESSIONS.remove(player) != null) {
            KingdomsLang.COMMAND_NEXUS_DISABLED.sendMessage((CommandSender)player);
            if (KingdomsConfig.NEXUS_ACTIONBAR_ENABLED.getBoolean()) {
                KingdomsLang.COMMAND_NEXUS_DEACTIVATED.sendMessage((CommandSender)player);
            }
            return CommandResult.FAILED;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasKingdom()) {
            KingdomsLang.NO_KINGDOM_DEFAULT.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        Kingdom kingdom = kp.getKingdom();
        if (KingdomsConfig.NEXUS_DISABLE_PLACE_MODE_OUT_OF_LAND.getBoolean() && !kp.getKingdom().isClaimed(SimpleChunkLocation.of(player.getLocation()))) {
            KingdomsLang.COMMAND_NEXUS_OUTSIDE_OF_LAND.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        if (!kp.hasPermission(StandardKingdomPermission.STRUCTURES)) {
            StandardKingdomPermission.STRUCTURES.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        if (!kp.isAdmin() && KingdomsConfig.Invasions.ALLOW_MOVING_NEXUS.getManager().getBoolean() && (nexus = kingdom.getNexus()) != null && (land = nexus.toSimpleChunkLocation().getLand()) != null && land.isBeingInvaded()) {
            KingdomsLang.COMMAND_NEXUS_INVASION.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        CommandNexus.startSession(player, kingdom);
        return CommandResult.SUCCESS;
    }

    public static void startSession(Player player, Kingdom kingdom) {
        SESSIONS.put(player, kingdom.getId());
        CommandNexus.actionBar(player);
        CommandNexus.preview(player, kingdom, false, () -> SESSIONS.containsKey(player));
        KingdomsLang.COMMAND_NEXUS_HELP.sendMessage((CommandSender)player);
    }

    public static boolean handleBlock(PlayerInteractEvent event, boolean replacing) {
        XMaterial base;
        Player player = event.getPlayer();
        Block finalBlock = event.getClickedBlock();
        if (!replacing) {
            finalBlock = finalBlock.getRelative(event.getBlockFace());
        }
        if (XTag.anyMatch((Object)(base = XMaterial.matchXMaterial((Material)finalBlock.getType())), (Collection)XTag.stringMatcher(KingdomsConfig.NEXUS_REPLACE_BLOCKS_LIST.getStringList(), null))) {
            if (KingdomsConfig.NEXUS_REPLACE_BLOCKS_BLACKLIST.getBoolean()) {
                KingdomsLang.COMMAND_NEXUS_CANNOT_REPLACE.sendMessage((CommandSender)player);
                return true;
            }
        } else if (!KingdomsConfig.NEXUS_REPLACE_BLOCKS_BLACKLIST.getBoolean()) {
            KingdomsLang.COMMAND_NEXUS_CANNOT_REPLACE.sendMessage((CommandSender)player);
            return true;
        }
        return false;
    }

    @EventHandler
    public void onNexusPlace(PlayerInteractEvent event) {
        boolean replacing;
        Location location = event.getPlayer().getLocation();
        location.add(2.0, 1.0, 2.0);
        Block clicked = event.getClickedBlock();
        if (clicked == null) {
            return;
        }
        if (event.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        Player player = event.getPlayer();
        UUID kingdomId = SESSIONS.get(player);
        if (kingdomId == null) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer(player.getUniqueId());
        Kingdom kingdom = Kingdom.getKingdom(kingdomId);
        Objects.requireNonNull(kingdom, () -> "Kingdom with ID " + kingdomId + " expired during nexus placement by " + player);
        event.setCancelled(true);
        boolean rightClick = event.getAction() == Action.RIGHT_CLICK_BLOCK;
        boolean replaceLeft = KingdomsConfig.NEXUS_REPLACE_LEFT_CLICK.getBoolean();
        boolean replaceRight = KingdomsConfig.NEXUS_REPLACE_RIGHT_CLICK.getBoolean();
        boolean bl = replacing = rightClick ? replaceRight : replaceLeft;
        if (SimpleLocation.of(clicked).equals(kingdom.getNexus())) {
            KingdomsLang.COMMAND_NEXUS_ALREADY_THERE.sendError((CommandSender)player, new Object[0]);
            return;
        }
        if (LocationUtils.exceedsBuildLimit(event)) {
            KingdomsConfig.errorSound(player);
            return;
        }
        if (CommandNexus.handleBlock(event, replacing)) {
            return;
        }
        Block target = CommandNexus.predicateNexusBlock(player, clicked, event.getBlockFace(), replacing, true);
        if (target == null) {
            MessageHandler.sendPlayerMessage(player, "&4Failed to predicate nexus block direction with facing " + event.getBlockFace());
            KingdomsConfig.errorSound(player);
            return;
        }
        Location nexus = target.getLocation();
        SimpleLocation simLoc = SimpleLocation.of(nexus);
        SimpleChunkLocation chunk = SimpleChunkLocation.of(target);
        if (!kingdom.isClaimed(chunk)) {
            KingdomsLang.COMMAND_NEXUS_NOT_CLAIMED.sendError((CommandSender)player, new Object[0]);
            return;
        }
        Land land = Land.getLand(chunk);
        if (land != null && land.getStructure(struct -> ((StructureType)((StructureStyle)struct.getStyle()).getType()).isNationalNexus()) != null) {
            KingdomsLang.COMMAND_NEXUS_ANOTHER_STRUCTURE.sendMessage((CommandSender)player);
            return;
        }
        if (land.isKingdomBlock(simLoc.toBlockVector())) {
            KingdomsLang.COMMAND_NEXUS_ANOTHER_ITEM.sendError((CommandSender)player, new Object[0]);
            return;
        }
        NexusMoveEvent nexusStructure = kingdom.placeOrMoveNexus(BukkitAdapter.adapt(nexus), kp);
        if (nexusStructure.isCancelled()) {
            return;
        }
        KingdomsLang.COMMAND_NEXUS_SUCCESS.sendMessage((CommandSender)player, "x", nexus.getBlockX(), "y", nexus.getBlockY(), "z", nexus.getBlockZ());
        SESSIONS.remove(player);
        CommandNexus.particles(nexus);
    }

    public static void particles(Location nexus) {
        Particles.helix((Plugin)Kingdoms.get(), (int)5, (double)2.0, (double)0.1, (double)1.0, (double)3.0, (double)0.1, (double)5.0, (boolean)true, (boolean)false, (ParticleDisplay)ParticleDisplay.of((XParticle)XParticle.DRAGON_BREATH).withLocation(nexus.add(0.5, 0.0, 0.5)).withDirection(new Vector(0, 1, 0)));
        ParticleDisplay.of((XParticle)XParticle.PORTAL).withLocation(nexus.add(0.0, 0.25, 0.0)).withCount(500).withExtra(3.0).spawn();
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        SESSIONS.remove(event.getPlayer());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onDamage(EntityDamageByEntityEvent event) {
        if (event.getEntity() instanceof Player && KingdomsConfig.NEXUS_DISABLE_PLACE_MODE_ON_DAMAGE.getBoolean() && SESSIONS.remove(event.getEntity()) != null) {
            KingdomsLang.COMMAND_NEXUS_DISABLED_ON_DAMAGE.sendMessage((CommandSender)event.getEntity());
        }
    }

    @EventHandler
    public void onMemberLeave(KingdomLeaveEvent event) {
        SESSIONS.remove(event.getPlayer().getPlayer());
    }

    @EventHandler(ignoreCancelled=true)
    public void onKingdomDisband(KingdomDisbandEvent event) {
        for (Player member : event.getKingdom().getOnlineMembers()) {
            SESSIONS.remove(member);
        }
    }

    @EventHandler
    public void onChunkChange(LandChangeEvent event) {
        if (!KingdomsConfig.NEXUS_DISABLE_PLACE_MODE_OUT_OF_LAND.getBoolean()) {
            return;
        }
        Player player = event.getPlayer();
        KingdomPlayer kp = event.getKingdomPlayer();
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            return;
        }
        if (!kingdom.isClaimed(event.getToChunk()) && SESSIONS.remove(player) != null) {
            KingdomsLang.COMMAND_NEXUS_DISABLED_ON_LAND_CHANGE.sendMessage((CommandSender)player);
            if (KingdomsConfig.NEXUS_ACTIONBAR_ENABLED.getBoolean()) {
                KingdomsLang.COMMAND_NEXUS_DEACTIVATED.sendMessage((CommandSender)player);
            }
        }
    }
}

