/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.jail;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.structures.objects.JailStructure;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.managers.buildings.structures.JailManager;
import org.kingdoms.utils.KingdomsBukkitExtensions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/kingdoms/commands/general/jail/CommandUnjail;", "Lorg/kingdoms/commands/KingdomsCommand;", "<init>", "()V", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "tabComplete", "", "", "Lorg/kingdoms/commands/CommandTabContext;", "core"})
@SourceDebugExtension(value={"SMAP\nCommandUnjail.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandUnjail.kt\norg/kingdoms/commands/general/jail/CommandUnjail\n+ 2 KingdomsBukkitExtensions.kt\norg/kingdoms/utils/KingdomsBukkitExtensions\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n33#2:53\n39#2:57\n33#2:61\n1557#3:54\n1628#3,2:55\n1630#3:58\n774#3:59\n865#3:60\n866#3:62\n1557#3:63\n1628#3,3:64\n*S KotlinDebug\n*F\n+ 1 CommandUnjail.kt\norg/kingdoms/commands/general/jail/CommandUnjail\n*L\n27#1:53\n45#1:57\n46#1:61\n45#1:54\n45#1:55,2\n45#1:58\n46#1:59\n46#1:60\n46#1:62\n47#1:63\n47#1:64,3\n*E\n"})
public final class CommandUnjail
extends KingdomsCommand {
    public CommandUnjail() {
        super("unjail", true);
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = context.getKingdomPlayer();
        Kingdom kingdom = context.getKingdom();
        Intrinsics.checkNotNull((Object)kingdom);
        Kingdom kingdom2 = kingdom;
        if (!kp.hasPermission(StandardKingdomPermission.JAIL)) {
            CommandResult commandResult = context.fail(StandardKingdomPermission.JAIL.getDeniedMessage());
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        OfflinePlayer offlinePlayer = context.getOfflinePlayer(0);
        if (offlinePlayer == null) {
            return CommandResult.FAILED;
        }
        OfflinePlayer target = offlinePlayer;
        KingdomsBukkitExtensions kingdomsBukkitExtensions = KingdomsBukkitExtensions.INSTANCE;
        OfflinePlayer $this$asKingdomPlayer$iv = target;
        boolean $i$f$asKingdomPlayer = false;
        KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer($this$asKingdomPlayer$iv);
        Intrinsics.checkNotNullExpressionValue((Object)kingdomPlayer, (String)"getKingdomPlayer(...)");
        KingdomPlayer targetKp = kingdomPlayer;
        if (!kingdom2.isMember(target)) {
            CommandResult commandResult = context.fail(null);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        if (targetKp.getJailCell() == null) {
            CommandResult commandResult = context.fail(null);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        JailStructure jailStructure = JailManager.Companion.getCell(target);
        Intrinsics.checkNotNull((Object)jailStructure);
        JailStructure cell = jailStructure;
        cell.release();
        return CommandResult.SUCCESS;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandTabContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isPlayer()) {
            Kingdom kingdom = context.getKingdom();
            if (kingdom == null) {
                List<String> list = KingdomsCommand.emptyTab();
                Intrinsics.checkNotNullExpressionValue(list, (String)"emptyTab(...)");
                return list;
            }
            Kingdom kingdom2 = kingdom;
            if (context.isAtArg(0)) {
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                OfflinePlayer x;
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Set<UUID> set = kingdom2.getMembers();
                Intrinsics.checkNotNullExpressionValue(set, (String)"getMembers(...)");
                Iterable iterable = set;
                int n = 0;
                CommandTabContext commandTabContext = context;
                boolean $i$f$map = false;
                void var5_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    UUID uUID = (UUID)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    KingdomsBukkitExtensions kingdomsBukkitExtensions = KingdomsBukkitExtensions.INSTANCE;
                    Intrinsics.checkNotNull((Object)x);
                    void $this$asOfflinePlayer$iv = x;
                    boolean $i$f$asOfflinePlayer = false;
                    OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)$this$asOfflinePlayer$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)offlinePlayer, (String)"getOfflinePlayer(...)");
                    collection.add((String)offlinePlayer);
                }
                collection = (List)destination$iv$iv;
                $this$map$iv = collection;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    x = (OfflinePlayer)element$iv$iv;
                    boolean bl = false;
                    KingdomsBukkitExtensions this_$iv = KingdomsBukkitExtensions.INSTANCE;
                    OfflinePlayer $this$asKingdomPlayer$iv = x;
                    boolean $i$f$asKingdomPlayer = false;
                    KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer($this$asKingdomPlayer$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)kingdomPlayer, (String)"getKingdomPlayer(...)");
                    if (!(kingdomPlayer.getJailCell() != null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                collection = (List)destination$iv$iv;
                $this$filter$iv = collection;
                $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    x = (OfflinePlayer)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(x.getName());
                }
                collection = (List)destination$iv$iv;
                List<String> list = commandTabContext.suggest(n, collection);
                Intrinsics.checkNotNullExpressionValue(list, (String)"suggest(...)");
                return list;
            }
        }
        List<String> list = KingdomsCommand.emptyTab();
        Intrinsics.checkNotNullExpressionValue(list, (String)"emptyTab(...)");
        return list;
    }
}

