/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.jail;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.gui.GUIBuilder;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.OptionHandler;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.utils.KingdomsBukkitExtensions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/kingdoms/commands/general/jail/CommandJail;", "Lorg/kingdoms/commands/KingdomsCommand;", "<init>", "()V", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "tabComplete", "", "", "Lorg/kingdoms/commands/CommandTabContext;", "core"})
@SourceDebugExtension(value={"SMAP\nCommandJail.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandJail.kt\norg/kingdoms/commands/general/jail/CommandJail\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KingdomsBukkitExtensions.kt\norg/kingdoms/utils/KingdomsBukkitExtensions\n*L\n1#1,63:1\n1557#2:64\n1628#2,2:65\n1630#2:68\n1628#2,3:69\n39#3:67\n*S KotlinDebug\n*F\n+ 1 CommandJail.kt\norg/kingdoms/commands/general/jail/CommandJail\n*L\n57#1:64\n57#1:65,2\n57#1:68\n57#1:69,3\n57#1:67\n*E\n"})
public final class CommandJail
extends KingdomsCommand {
    public CommandJail() {
        super("jail", true);
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = context.getKingdomPlayer();
        Kingdom kingdom = context.getKingdom();
        Intrinsics.checkNotNull((Object)kingdom);
        Kingdom kingdom2 = kingdom;
        if (!kp.hasPermission(StandardKingdomPermission.JAIL)) {
            CommandResult commandResult = context.fail(StandardKingdomPermission.JAIL.getDeniedMessage());
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        OfflinePlayer offlinePlayer = context.getOfflinePlayer(0);
        if (offlinePlayer == null) {
            return CommandResult.FAILED;
        }
        OfflinePlayer target = offlinePlayer;
        GUIBuilder gUIBuilder = new GUIBuilder(KingdomsGUI.STRUCTURES_OUTPOST);
        Intrinsics.checkNotNull((Object)player);
        Object t = gUIBuilder.forPlayer(player).build();
        Intrinsics.checkNotNull(t);
        Object gui = t;
        ((InteractiveGUI)gui).option("cell").onNormalClicks(CommandJail::execute$lambda$0).done();
        ((InteractiveGUI)gui).option("duration").onNormalClicks(CommandJail::execute$lambda$1).done();
        ((InteractiveGUI)gui).option("bail").onNormalClicks(CommandJail::execute$lambda$2).done();
        ((InteractiveGUI)gui).option("free-hours").onNormalClicks(CommandJail::execute$lambda$3).done();
        ((InteractiveGUI)gui).option("required-items").onNormalClicks(CommandJail::execute$lambda$4).done();
        ((InteractiveGUI)gui).option("done").onNormalClicks(CommandJail::execute$lambda$5).done();
        InteractiveGUI.open$default(gui, false, false, 3, null);
        return CommandResult.SUCCESS;
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandTabContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isPlayer()) {
            Kingdom kingdom = context.getKingdom();
            if (kingdom == null) {
                List<String> list = KingdomsCommand.emptyTab();
                Intrinsics.checkNotNullExpressionValue(list, (String)"emptyTab(...)");
                return list;
            }
            Kingdom kingdom2 = kingdom;
            if (context.isAtArg(0)) {
                OfflinePlayer x;
                Collection<String> collection;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Set<UUID> set = kingdom2.getMembers();
                Intrinsics.checkNotNullExpressionValue(set, (String)"getMembers(...)");
                Iterable iterable = set;
                int n = 0;
                CommandTabContext commandTabContext = context;
                boolean $i$f$map = false;
                void var5_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    UUID uUID = (UUID)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    KingdomsBukkitExtensions kingdomsBukkitExtensions = KingdomsBukkitExtensions.INSTANCE;
                    Intrinsics.checkNotNull((Object)x);
                    void $this$asOfflinePlayer$iv = x;
                    boolean $i$f$asOfflinePlayer = false;
                    OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)$this$asOfflinePlayer$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)offlinePlayer, (String)"getOfflinePlayer(...)");
                    collection.add((String)offlinePlayer);
                }
                collection = (List)destination$iv$iv;
                $this$map$iv = collection;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    x = (OfflinePlayer)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(x.getName());
                }
                collection = (List)destination$iv$iv;
                List<String> list = commandTabContext.suggest(n, collection);
                Intrinsics.checkNotNullExpressionValue(list, (String)"suggest(...)");
                return list;
            }
        }
        List<String> list = KingdomsCommand.emptyTab();
        Intrinsics.checkNotNullExpressionValue(list, (String)"emptyTab(...)");
        return list;
    }

    private static final void execute$lambda$0(OptionHandler ctx) {
    }

    private static final void execute$lambda$1(OptionHandler ctx) {
    }

    private static final void execute$lambda$2(OptionHandler ctx) {
    }

    private static final void execute$lambda$3(OptionHandler ctx) {
    }

    private static final void execute$lambda$4(OptionHandler ctx) {
    }

    private static final void execute$lambda$5(OptionHandler ctx) {
    }
}

