/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.invitations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.general.invitations.CommandAccept;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.managers.inviterequests.JoinRequests;
import org.kingdoms.utils.KingdomsBukkitExtensions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/kingdoms/commands/general/invitations/CommandRequestJoin;", "Lorg/kingdoms/commands/KingdomsCommand;", "<init>", "()V", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "tabComplete", "", "", "Lorg/kingdoms/commands/CommandTabContext;", "core"})
@SourceDebugExtension(value={"SMAP\nCommandJoinRequests.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandJoinRequests.kt\norg/kingdoms/commands/general/invitations/CommandRequestJoin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KingdomsBukkitExtensions.kt\norg/kingdoms/utils/KingdomsBukkitExtensions\n*L\n1#1,112:1\n774#2:113\n865#2:114\n866#2:116\n1863#2,2:117\n33#3:115\n*S KotlinDebug\n*F\n+ 1 CommandJoinRequests.kt\norg/kingdoms/commands/general/invitations/CommandRequestJoin\n*L\n37#1:113\n37#1:114\n37#1:116\n39#1:117,2\n38#1:115\n*E\n"})
public final class CommandRequestJoin
extends KingdomsCommand {
    public CommandRequestJoin() {
        super("requestJoin", true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        KingdomPlayer kp = context.getKingdomPlayer();
        if (kp.hasKingdom()) {
            CommandResult commandResult = context.fail(KingdomsLang.COMMAND_JOIN_ALREADY_IN_KINGDOM);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        Kingdom kingdom = context.getKingdom(0);
        if (kingdom == null) {
            return CommandResult.FAILED;
        }
        Kingdom requestedKingdom = kingdom;
        if (JoinRequests.Companion.getJoinRequests(requestedKingdom).containsKey(kp.getId())) {
            CommandResult commandResult = context.fail(KingdomsLang.COMMAND_REQUESTJOIN_ALREADY_SENT);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        KingdomsLang kingdomsLang = CommandAccept.checkRequirementsToJoin(context.senderAsPlayer(), requestedKingdom);
        if (kingdomsLang != null) {
            KingdomsLang it = kingdomsLang;
            boolean bl = false;
            CommandResult commandResult = context.fail(it);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        List<Player> list = requestedKingdom.getOnlineMembers();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getOnlineMembers(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable it = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Player x = (Player)element$iv$iv;
            boolean bl = false;
            KingdomsBukkitExtensions kingdomsBukkitExtensions = KingdomsBukkitExtensions.INSTANCE;
            Intrinsics.checkNotNull((Object)x);
            OfflinePlayer $this$asKingdomPlayer$iv = (OfflinePlayer)x;
            boolean $i$f$asKingdomPlayer = false;
            KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer($this$asKingdomPlayer$iv);
            Intrinsics.checkNotNullExpressionValue((Object)kingdomPlayer, (String)"getKingdomPlayer(...)");
            if (!kingdomPlayer.hasPermission(StandardKingdomPermission.INVITE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player x = (Player)element$iv;
            boolean bl = false;
            context.sendMessage((CommandSender)x, KingdomsLang.COMMAND_REQUESTJOIN_SENT_ANNOUNCE, new Object[0]);
        }
        context.getMessageContext().withContext(requestedKingdom);
        context.sendMessage((Messenger)KingdomsLang.COMMAND_REQUESTJOIN_SENT, new Object[0]);
        Intrinsics.checkNotNull((Object)kp);
        JoinRequests.Companion.sendJoinRequestTo(kp, requestedKingdom);
        return CommandResult.SUCCESS;
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandTabContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List<String> list = context.getKingdoms(0);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getKingdoms(...)");
        return list;
    }
}

