/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.invitations;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.general.invitations.CommandAccept;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;

public class CommandJoin
extends KingdomsCommand {
    public CommandJoin() {
        super("join", true);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (kp.hasKingdom()) {
            KingdomsLang.COMMAND_JOIN_ALREADY_IN_KINGDOM.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        Kingdom kingdom = context.getKingdom(0);
        if (kingdom == null) {
            return CommandResult.FAILED;
        }
        if (kingdom.requiresInvite()) {
            KingdomsLang.COMMAND_JOIN_REQUIRES_INVITE.sendMessage((CommandSender)player, "kingdom", kingdom.getName());
            return CommandResult.FAILED;
        }
        KingdomsLang requirement = CommandAccept.checkRequirementsToJoin(player, kingdom);
        if (requirement != null) {
            requirement.sendError((CommandSender)player, new MessagePlaceholderProvider().withContext(kingdom));
        }
        kp.joinKingdom(kingdom);
        for (Player members : kingdom.getOnlineMembers()) {
            context.sendMessage((CommandSender)members, KingdomsLang.COMMAND_JOIN_JOINED, new Object[0]);
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public List<String> tabComplete(CommandTabContext context) {
        if (context.isPlayer() && context.isAtArg(0)) {
            KingdomPlayer kp = context.getKingdomPlayer();
            if (kp.hasKingdom()) {
                return new ArrayList<String>();
            }
            return context.getKingdoms(0);
        }
        return new ArrayList<String>();
    }
}

