/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.invitations;

import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.general.invitations.CommandAccept;
import org.kingdoms.commands.general.invitations.CommandDecline;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomInvite;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.utils.time.TimeFormatter;
import org.kingdoms.utils.time.TimeUtils;

public class CommandInvites
extends KingdomsCommand {
    public CommandInvites() {
        super("invites", true);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        if (context.getKingdomPlayer().getInvites().isEmpty()) {
            context.sendError(KingdomsLang.COMMAND_INVITES_NO_INVITES, new Object[0]);
            return CommandResult.FAILED;
        }
        CommandInvites.openInvitesGUI(player);
        return CommandResult.SUCCESS;
    }

    public static InteractiveGUI openInvitesGUI(Player player) {
        InteractiveGUI gui = GUIAccessor.prepare(player, KingdomsGUI.INVITES);
        if (gui == null) {
            return null;
        }
        gui.push("back", () -> ((Player)player).closeInventory(), new Object[0]);
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        ReusableOptionHandler inviteOpt = gui.getReusableOption("invite");
        for (Map.Entry<UUID, KingdomInvite> inviteEntry : kp.getInvites().entrySet()) {
            KingdomInvite invite = inviteEntry.getValue();
            OfflinePlayer sender = Bukkit.getOfflinePlayer((UUID)invite.getSender());
            boolean expired = !invite.canAccept();
            UUID kingdomId = inviteEntry.getKey();
            ((ReusableOptionHandler)inviteOpt.setEdits("expired", expired, "timestamp", TimeUtils.getDateAndTime(invite.getTimestamp()), "time-passed", TimeFormatter.of(System.currentTimeMillis() - invite.getTimestamp()), "time-left-to-accpet", TimeFormatter.of(invite.getTimeLeftToAccept())).on(ClickType.LEFT, context -> {
                if (!expired) {
                    if (kp.hasKingdom()) {
                        context.sendError(KingdomsLang.COMMAND_ACCEPT_ALREADY_IN_KINGDOM, new Object[0]);
                        return;
                    }
                    CommandAccept.acceptInvite(player, Kingdom.getKingdom(kingdomId));
                }
                kp.getInvites().remove(kingdomId);
                CommandInvites.openInvitesGUI(player);
            })).on(ClickType.RIGHT, () -> {
                CommandDecline.decline(player, Kingdom.getKingdom(kingdomId));
                kp.getInvites().remove(kingdomId);
                CommandInvites.openInvitesGUI(player);
            }).pushHead(sender);
            if (inviteOpt.hasNext()) continue;
            break;
        }
        gui.push("decline-all", () -> {
            CommandDecline.declineAll(player);
            CommandInvites.openInvitesGUI(player);
        }, new Object[0]);
        gui.open();
        return gui;
    }
}

