/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.invitations;

import java.util.Map;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomInvite;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.locale.KingdomsLang;

public class CommandDecline
extends KingdomsCommand {
    public CommandDecline() {
        super("decline", true);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        Kingdom kingdom;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Map<UUID, KingdomInvite> invites = kp.getInvites();
        if (invites.isEmpty()) {
            KingdomsLang.COMMAND_DECLINE_NO_INVITES.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        if (!context.assertArgs(1)) {
            if (invites.size() != 1) {
                KingdomsLang.COMMAND_DECLINE_MULTIPLE_INVITES.sendMessage((CommandSender)player);
                return CommandResult.FAILED;
            }
            Map.Entry<UUID, KingdomInvite> inviteEntry = invites.entrySet().iterator().next();
            kingdom = Kingdom.getKingdom(inviteEntry.getKey());
        } else {
            if (context.argEquals(0, "*")) {
                CommandDecline.declineAll(player);
                return CommandResult.FAILED;
            }
            kingdom = context.getKingdom(0);
            if (kingdom == null) {
                return CommandResult.FAILED;
            }
        }
        CommandDecline.decline(player, kingdom);
        return CommandResult.SUCCESS;
    }

    public static void declineAll(Player player) {
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Map<UUID, KingdomInvite> invites = kp.getInvites();
        KingdomsLang.COMMAND_DECLINE_ALL.sendMessage((CommandSender)player, "invites", invites.size());
        for (UUID entry : invites.keySet().toArray(new UUID[0])) {
            CommandDecline.decline(player, Kingdom.getKingdom(entry));
        }
        invites.clear();
    }

    public static void decline(Player player, Kingdom kingdom) {
        if (kingdom == null) {
            KingdomsLang.COMMAND_DECLINE_NO_LONGER_EXISTS.sendMessage((CommandSender)player);
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        KingdomInvite invite = kp.getInvites().remove(kingdom.getId());
        if (invite == null) {
            KingdomsLang.COMMAND_DECLINE_NOT_INVITED.sendMessage((CommandSender)player, "kingdom", kingdom.getName());
            return;
        }
        if (!invite.canAccept()) {
            KingdomsLang.COMMAND_DECLINE_EXPIRED.sendMessage((CommandSender)player, "kingdom", kingdom.getName());
            return;
        }
        KingdomPlayer inviter = invite.getKingdomPlayer();
        OfflinePlayer inviterPlayer = inviter.getOfflinePlayer();
        KingdomsLang.COMMAND_DECLINE_DECLINED.sendMessage((CommandSender)player, "inviter", inviterPlayer.getName(), "kingdom", kingdom.getName());
        if (inviterPlayer.isOnline()) {
            KingdomsLang.COMMAND_DECLINE_NOTIFY.sendMessage((CommandSender)((Player)inviterPlayer), "name", player.getName());
        }
    }
}

