/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.invitations;

import java.util.Map;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomInvite;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.managers.daily.elections.Elections;
import org.kingdoms.managers.daily.elections.ElectionsManager;

public class CommandAccept
extends KingdomsCommand {
    public CommandAccept() {
        super("accept", true);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        Kingdom kingdom;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        new StaticMessenger("&2Hello, my kingdom's name is &9%kingdoms_kingdom_name%").sendMessage((CommandSender)context.senderAsPlayer());
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (kp.hasKingdom()) {
            KingdomsLang.COMMAND_ACCEPT_ALREADY_IN_KINGDOM.sendError((CommandSender)player, new Object[0]);
            return CommandResult.FAILED;
        }
        Map<UUID, KingdomInvite> invites = kp.getInvites();
        if (invites.isEmpty()) {
            KingdomsLang.COMMAND_ACCEPT_NO_INVITES.sendError((CommandSender)player, new Object[0]);
            return CommandResult.FAILED;
        }
        if (!context.assertArgs(1)) {
            if (invites.size() != 1) {
                KingdomsLang.COMMAND_ACCEPT_MULTIPLE_INVITES.sendError((CommandSender)player, new Object[0]);
                return CommandResult.FAILED;
            }
            Map.Entry<UUID, KingdomInvite> inviteEntry = invites.entrySet().iterator().next();
            kingdom = Kingdom.getKingdom(inviteEntry.getKey());
        } else {
            kingdom = context.getKingdom(0);
            if (kingdom == null) {
                return CommandResult.FAILED;
            }
        }
        CommandAccept.acceptInvite(player, kingdom);
        return CommandResult.SUCCESS;
    }

    public static void acceptInvite(Player player, Kingdom kingdom) {
        if (kingdom == null) {
            KingdomsLang.COMMAND_ACCEPT_NO_LONGER_EXISTS.sendError((CommandSender)player, new Object[0]);
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        KingdomInvite invite = kp.getInvites().remove(kingdom.getId());
        if (invite == null) {
            KingdomsLang.COMMAND_ACCEPT_NOT_INVITED.sendError((CommandSender)player, "kingdom", kingdom.getName());
            return;
        }
        if (!invite.canAccept()) {
            KingdomsLang.COMMAND_ACCEPT_EXPIRED.sendError((CommandSender)player, "kingdom", kingdom.getName());
            return;
        }
        KingdomPlayer inviter = invite.getKingdomPlayer();
        OfflinePlayer inviterPlayer = inviter.getOfflinePlayer();
        KingdomsLang requirement = CommandAccept.checkRequirementsToJoin(player, kingdom);
        if (requirement != null) {
            requirement.sendError((CommandSender)player, new MessagePlaceholderProvider().withContext(kingdom));
            return;
        }
        if (kp.joinKingdom(kingdom, event -> event.getMetadata().put(KingdomInvite.NAMESPACE, (Object)invite)).isCancelled()) {
            return;
        }
        KingdomsLang.COMMAND_ACCEPT_ACCEPTED.sendMessage((CommandSender)player, "inviter", inviterPlayer.getName(), "kingdom", kingdom.getName());
        if (inviterPlayer.isOnline()) {
            KingdomsLang.COMMAND_ACCEPT_NOTIFY.sendMessage((CommandSender)((Player)inviterPlayer), "name", player.getName());
        }
        for (Player members : kingdom.getOnlineMembers()) {
            KingdomsLang.COMMAND_ACCEPT_JOINED.sendMessage((CommandSender)members, new MessagePlaceholderProvider().withContext(player));
        }
    }

    public static KingdomsLang checkRequirementsToJoin(Player player, Kingdom kingdom) {
        if (kingdom.isFull()) {
            return KingdomsLang.COMMAND_ACCEPT_MAX_MEMBERS;
        }
        if (Elections.KINGDOMS.getOption("disallow-joins").getBoolean() && Elections.KINGDOMS.isAcceptingVotes() && ElectionsManager.isEnabledFor(kingdom)) {
            return KingdomsLang.COMMAND_JOIN_ELECTIONS;
        }
        return null;
    }
}

