/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.invasions;

import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.gui.pagination.GUIMultiPagination;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.invasions.Invasion;

public class CommandSurrender
extends KingdomsCommand {
    public CommandSurrender() {
        super("surrender", true);
    }

    public static InteractiveGUI openSurrenderGUI(Player player, int page) {
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        InteractiveGUI gui = GUIAccessor.prepare(player, KingdomsGUI.SURRENDER);
        if (gui == null) {
            return null;
        }
        GUIMultiPagination<Invasion, Invasion.Result> pagination = new GUIMultiPagination<Invasion, Invasion.Result>(gui, page, newPage -> CommandSurrender.openSurrenderGUI(player, newPage));
        gui.option("invasion").onNormalClicks(ctx -> {
            Invasion invasion = kp.getInvasion();
            if (invasion.hasEnded()) {
                ctx.sendError(KingdomsLang.COMMAND_SURRENDER_ALREADY_ENDED, new Object[0]);
                return;
            }
            invasion.end(Invasion.Result.ATTACKER_SURRENDERED);
        }).done();
        pagination.paginate("attacking", kingdom.getInvasions().values(), Invasion.Result.ATTACKER_SURRENDERED);
        pagination.paginate("defending", kingdom.getLands().stream().filter(Land::isBeingInvaded).map(x -> x.getInvasions().get(kingdom.getId())).filter(Objects::nonNull).collect(Collectors.toList()), Invasion.Result.DEFENDER_SURRENDERED);
        for (GUIMultiPagination.MappedOption mappedOption : pagination.paginate()) {
            ReusableOptionHandler option = mappedOption.getOption();
            for (Invasion invasion : mappedOption.getCollection()) {
                option.setSettings(invasion.getMessageContext());
                option.onNormalClicks(ctx -> invasion.end((Invasion.Result)((Object)((Object)mappedOption.getSpecial()))));
                mappedOption.done();
            }
        }
        gui.open();
        return gui;
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasPermission(StandardKingdomPermission.INVADE)) {
            context.sendError(KingdomsLang.COMMAND_SURRENDER_DEFENDER_PERMISSION, new Object[0]);
            return CommandResult.FAILED;
        }
        if (kp.isInvading()) {
            Invasion invasion = kp.getInvasion();
            invasion.end(Invasion.Result.ATTACKER_SURRENDERED);
        } else {
            CommandSurrender.openSurrenderGUI(player, 0);
        }
        return CommandResult.SUCCESS;
    }
}

