/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.invasions;

import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.logs.misc.LogGroupShieldDeactivate;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;

public class CommandShield
extends KingdomsCommand {
    public CommandShield() {
        super("shield", true);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        KingdomPlayer kp = context.getKingdomPlayer();
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            context.sendError(KingdomsLang.NO_KINGDOM_DEFAULT, new Object[0]);
            return CommandResult.FAILED;
        }
        if (!kp.hasPermission(StandardKingdomPermission.SETTINGS)) {
            StandardKingdomPermission.SETTINGS.sendDeniedMessage(context.senderAsPlayer());
            return CommandResult.FAILED;
        }
        long shieldLeft = kingdom.getShield().getTimeLeft().toMillis();
        if (shieldLeft <= 0L) {
            context.sendError(KingdomsLang.COMMAND_SHIELD_NO_SHIELD, new Object[0]);
            return CommandResult.FAILED;
        }
        if (!context.assertArgs(1) || !context.arg(0).equalsIgnoreCase("confirm")) {
            context.sendError(KingdomsLang.COMMAND_SHIELD_CONFIRM, new Object[0]);
            return CommandResult.FAILED;
        }
        for (Player member : kingdom.getOnlineMembers()) {
            KingdomsLang.COMMAND_SHIELD_DEACTIVATED.sendMessage((CommandSender)member, "executor", context.senderAsPlayer().getName());
        }
        kingdom.getShield().deactivate();
        kingdom.log(new LogGroupShieldDeactivate(kp.getId(), shieldLeft));
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            return CommandShield.tabComplete("confirm");
        }
        return CommandShield.emptyTab();
    }
}

