/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.invasions;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.data.Pair;
import org.kingdoms.events.invasion.KingdomPreInvadeEvent;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.builders.LanguageEntryWithContext;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.managers.Masswar;
import org.kingdoms.managers.invasions.Invasion;
import org.kingdoms.managers.invasions.InvasionFactory;
import org.kingdoms.managers.land.protection.MiscUpgradeManager;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.cooldown.Cooldown;
import org.kingdoms.utils.internal.numbers.Numbers;
import org.kingdoms.utils.kingdoms.Shields;
import org.kingdoms.utils.time.TimeFormatter;

public class CommandInvade
extends KingdomsCommand {
    private static final Cooldown<UUID> SHIELD_CONFIRMATION = new Cooldown();

    public CommandInvade() {
        super("invade", true);
    }

    private static CommandResult newbieProtection(CommandContext context, Kingdom kingdom, boolean defender) {
        long currTime = System.currentTimeMillis();
        Long kingdomProtection = KingdomsConfig.CREATION_KINGDOMS_NEWBIE_PROTECTION.getTimeMillis();
        if (kingdomProtection != null && kingdomProtection > 0L) {
            long kingdomAge = currTime - kingdom.getSince();
            context.var("kingdom-newbie-protection", TimeFormatter.of(kingdomProtection));
            context.var("kingdom-newbie-protection-left", TimeFormatter.of(Math.max(0L, kingdomProtection - kingdomAge)));
            if (kingdomAge < kingdomProtection) {
                KingdomsLang lang = defender ? KingdomsLang.COMMAND_INVADE_NEWBIE_PROTECTION_DEFENDER_KINGDOM : KingdomsLang.COMMAND_INVADE_NEWBIE_PROTECTION_ATTACKER_KINGDOM;
                return context.fail(lang);
            }
        }
        Nation nation = kingdom.getNation();
        Long nationProtection = KingdomsConfig.CREATION_NATIONS_NEWBIE_PROTECTION.getTimeMillis();
        if (nationProtection != null && nationProtection > 0L && nation != null) {
            long nationAge = currTime - nation.getSince();
            context.var("nation-newbie-protection", TimeFormatter.of(nationProtection));
            context.var("nation-newbie-protection-left", TimeFormatter.of(Math.max(0L, nationProtection - nationAge)));
            if (nationAge < nationProtection) {
                KingdomsLang lang = defender ? KingdomsLang.COMMAND_INVADE_NEWBIE_PROTECTION_DEFENDER_NATION : KingdomsLang.COMMAND_INVADE_NEWBIE_PROTECTION_ATTACKER_NATION;
                return context.fail(lang);
            }
        }
        return null;
    }

    public static CommandResult execute(CommandContext context, boolean ransack) {
        KingdomPreInvadeEvent invasion;
        int invading;
        boolean notAdmin;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (kp.isInvading()) {
            KingdomsLang.COMMAND_INVADE_ALREADY_INVADING.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        if (!kp.hasPermission(StandardKingdomPermission.INVADE)) {
            StandardKingdomPermission.INVADE.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        if (!kp.hasPermission(StandardKingdomPermission.CLAIM)) {
            return context.fail(KingdomsLang.COMMAND_INVADE_NO_CLAIM_PERMISSION);
        }
        boolean bl = notAdmin = !kp.isAdmin();
        if (notAdmin && KingdomsConfig.Invasions.MASSWAR_DURING_MASSWAR_ONLY.getManager().getBoolean() && !Masswar.getInstance().isRunning()) {
            KingdomsLang.COMMAND_INVADE_MASSWAR_ONLY.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        if (notAdmin && PlayerUtils.invulnerableGameMode(player)) {
            KingdomsLang.COMMAND_INVADE_CREATIVE.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        Kingdom attackerKingdom = kp.getKingdom();
        if (notAdmin && !MiscUpgradeManager.canInvade(attackerKingdom)) {
            KingdomsLang.COMMAND_INVADE_MAX_MISC_UPGRADE.sendError((CommandSender)player, new Object[0]);
            return CommandResult.FAILED;
        }
        int sim = KingdomsConfig.Invasions.SIMULTANEOUS_INVASIONS.getManager().getInt();
        if (sim > 0 && (invading = attackerKingdom.getInvasions().size()) >= sim) {
            KingdomsLang.COMMAND_INVADE_SIMULTANEOUS.sendMessage((CommandSender)player, "amount", sim);
            return CommandResult.FAILED;
        }
        Land land = Land.getLand(player.getLocation());
        if (land == null || !land.isClaimed()) {
            KingdomsLang.COMMAND_INVADE_NOT_CLAIMED.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        if (land.isBeingInvaded()) {
            KingdomsLang.COMMAND_INVADE_ALREADY_BEING_INVADED.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        Kingdom defenderKingdom = land.getKingdom();
        if (defenderKingdom.getId().equals(attackerKingdom.getId())) {
            KingdomsLang.COMMAND_INVADE_OWN_LAND.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        if (notAdmin && !attackerKingdom.hasAttribute(defenderKingdom, (RelationAttribute)StandardRelationAttribute.INVADE)) {
            KingdomRelation relation = attackerKingdom.getRelationWith(defenderKingdom);
            LanguageEntryWithContext messageObjectBuilder = relation.getName();
            MessagePlaceholderProvider settings = context.getMessageContext();
            context.var("relation", relation.getColor() + messageObjectBuilder.buildPlain(settings));
            return context.fail(KingdomsLang.COMMAND_INVADE_CEASEFIRE);
        }
        if (notAdmin && KingdomsConfig.Invasions.PACIFISM_ENABLED.getManager().getBoolean() && (!Masswar.getInstance().isRunning() || !KingdomsConfig.Invasions.MASSWAR_ALLOW_INVADING_PACIFISTS.getManager().getBoolean())) {
            if (attackerKingdom.isPacifist()) {
                KingdomsLang.COMMAND_INVADE_SELF_PACIFIST.sendError((CommandSender)player, new Object[0]);
                return CommandResult.FAILED;
            }
            if (defenderKingdom.isPacifist()) {
                KingdomsLang.COMMAND_INVADE_PACIFIST.sendError((CommandSender)player, new Object[0]);
                return CommandResult.FAILED;
            }
        }
        if (!kp.isAdmin() && attackerKingdom.isStrongerThan(defenderKingdom)) {
            return context.fail(KingdomsLang.COMMAND_INVADE_HIGHER_STRENGTH);
        }
        if (!kp.isAdmin() && KingdomsConfig.Invasions.CHALLENGES_ENABLED.getManager().getBoolean()) {
            boolean challengeNull;
            long challengeTime;
            Long challenge = defenderKingdom.getChallenges().get(attackerKingdom.getId());
            Long opponentChallenge = attackerKingdom.getChallenges().get(defenderKingdom.getId());
            if (challenge == null && opponentChallenge == null) {
                Pair<Integer, Integer> defendersNeeded = InvasionFactory.meetsMinOnlineMembers(defenderKingdom, attackerKingdom, KingdomsConfig.Invasions.ONLINE_MEMBERS_DEFENDER);
                if (defendersNeeded != null && defendersNeeded.getKey() > defendersNeeded.getValue()) {
                    context.var("defenders", defendersNeeded.getKey()).var("online", defendersNeeded.getValue());
                    return context.fail(KingdomsLang.COMMAND_INVADE_MIN_DEFENDERS_NEEDED_CHALLENGE);
                }
                context.var("kingdom", defenderKingdom.getName());
                return context.fail(KingdomsLang.COMMAND_INVADE_NOT_CHALLENGED);
            }
            long currTime = System.currentTimeMillis();
            if (currTime < (challengeTime = ((challengeNull = challenge == null) ? opponentChallenge : challenge).longValue())) {
                context.var("kingdom", defenderKingdom.getName()).var("remaining-time", TimeFormatter.of(challengeTime - currTime));
                return context.fail(challengeNull ? KingdomsLang.COMMAND_INVADE_CHALLENGE_NOT_STARTED_OPPONENT : KingdomsLang.COMMAND_INVADE_CHALLENGE_NOT_STARTED);
            }
        }
        if (notAdmin) {
            Pair<Long, Boolean> cd = Invasion.getCooldown(attackerKingdom, defenderKingdom);
            if (cd != null) {
                (cd.getValue() != false ? KingdomsLang.COMMAND_INVADE_COOLDOWN_SUCCESSFUL : KingdomsLang.COMMAND_INVADE_COOLDOWN_FAILED).sendMessage((CommandSender)player, "kingdom", defenderKingdom.getName(), "cooldown", TimeFormatter.of(cd.getKey()));
                return CommandResult.FAILED;
            }
            Pair<Integer, Integer> defendersNeeded = InvasionFactory.meetsMinOnlineMembers(defenderKingdom, attackerKingdom, KingdomsConfig.Invasions.ONLINE_MEMBERS_DEFENDER);
            if (defendersNeeded != null && defendersNeeded.getKey() > defendersNeeded.getValue()) {
                KingdomsLang.COMMAND_INVADE_MIN_DEFENDERS_NEEDED.sendMessage((CommandSender)player, "defenders", defendersNeeded.getValue(), "online", defendersNeeded.getValue());
                return CommandResult.FAILED;
            }
            Pair<Integer, Integer> invadersNeeded = InvasionFactory.meetsMinOnlineMembers(attackerKingdom, defenderKingdom, KingdomsConfig.Invasions.ONLINE_MEMBERS_INVADER);
            if (invadersNeeded != null && invadersNeeded.getKey() > invadersNeeded.getValue()) {
                KingdomsLang.COMMAND_INVADE_MIN_INVADERS_NEEDED.sendMessage((CommandSender)player, "invaders", invadersNeeded.getValue(), "online", invadersNeeded.getValue());
                return CommandResult.FAILED;
            }
        }
        if (notAdmin && InvasionFactory.coversAdjoiningProtection(land)) {
            KingdomsLang.COMMAND_INVADE_ADJOINING_PROTECTIOIN.sendError((CommandSender)player, new Object[0]);
            return CommandResult.FAILED;
        }
        Nation attackerNation = attackerKingdom.getNation();
        if (attackerNation != null && KingdomsConfig.Invasions.NATIONS_REQUIRES_NATIONAL_ENEMYSHIP.getManager().getBoolean() && !attackerNation.getKingdoms().stream().allMatch(x -> x.getRelationWith(defenderKingdom) == KingdomRelation.ENEMY)) {
            return context.fail(KingdomsLang.COMMAND_INVADE_NATIONS_REQUIRES_NATIONAL_ENEMYSHIP);
        }
        Nation defenderNation = defenderKingdom.getNation();
        if (notAdmin) {
            if (CommandInvade.newbieProtection(context, defenderKingdom, true) == CommandResult.FAILED) {
                return CommandResult.FAILED;
            }
            if (CommandInvade.newbieProtection(context, attackerKingdom, false) == CommandResult.FAILED) {
                return CommandResult.FAILED;
            }
        }
        Runnable deactivateShield = null;
        if (!(!notAdmin || Masswar.getInstance().isRunning() && KingdomsConfig.Invasions.MASSWAR_ALLOW_INVADING_SHIELDS.getManager().getBoolean())) {
            boolean forceNationShield = KingdomsConfig.Invasions.NATIONS_USE_SHIELD.getManager().getBoolean();
            long nationShieldAccessLoss = KingdomsConfig.Invasions.SHIELDS_NATION_SHIELD_ACCESS_LOSS.getManager().getTimeMillis();
            context.var("access-loss-time", TimeFormatter.of(nationShieldAccessLoss));
            Group shieldToUse = Shields.getShieldToUse(defenderKingdom);
            long shield = shieldToUse.getShield().getTimeLeft().toMillis();
            if (shield > 0L) {
                KingdomsLang lang = shieldToUse == defenderKingdom ? KingdomsLang.COMMAND_INVADE_SHIELD_DEFENDER_KINGDOM : KingdomsLang.COMMAND_INVADE_SHIELD_DEFENDER_NATION;
                lang.sendMessage((CommandSender)player, "shield", TimeFormatter.of(shield));
                return CommandResult.FAILED;
            }
            if (KingdomsConfig.Invasions.SHIELDS_DISALLOW_INVASIONS.getManager().getBoolean()) {
                shieldToUse = Shields.getShieldToUse(attackerKingdom);
                boolean useKingdomShield = shieldToUse == attackerKingdom;
                long shield2 = shieldToUse.getShield().getDuration().toMillis();
                if (shield2 > 0L) {
                    if (SHIELD_CONFIRMATION.isInCooldown(player.getUniqueId())) {
                        SHIELD_CONFIRMATION.stop(player.getUniqueId());
                        deactivateShield = !useKingdomShield && nationShieldAccessLoss > 0L ? () -> context.sendError(KingdomsLang.COMMAND_INVADE_SHIELD_INVADER_NATION_SHIELD_ACCESS_LOSS, new Object[0]) : () -> {
                            KingdomsLang lang = useKingdomShield ? KingdomsLang.COMMAND_INVADE_SHIELD_INVADER_KINGDOM_DISABLED : KingdomsLang.COMMAND_INVADE_SHIELD_INVADER_NATION_DISABLED;
                            lang.sendMessage((CommandSender)player, "shield", TimeFormatter.of(shield2), "invader", player.getName(), "kingdom", defenderKingdom.getName());
                            shieldToUse.getShield().deactivate();
                        };
                    } else {
                        KingdomsLang lang = useKingdomShield ? KingdomsLang.COMMAND_INVADE_SHIELD_INVADER_KINGDOM : KingdomsLang.COMMAND_INVADE_SHIELD_INVADER_NATION;
                        lang.sendMessage((CommandSender)player, "shield", TimeFormatter.of(shield2));
                        SHIELD_CONFIRMATION.add(player.getUniqueId(), 5L, TimeUnit.SECONDS);
                        return CommandResult.FAILED;
                    }
                }
            }
        }
        if (notAdmin && defenderNation != null && InvasionFactory.nationCapitalRadiusProtection(defenderNation, defenderKingdom, player, land)) {
            return CommandResult.FAILED;
        }
        Pair<Set<SimpleChunkLocation>, Map<SimpleChunkLocation, Structure>> results = InvasionFactory.getAffectedLands(land);
        Set<SimpleChunkLocation> acceptedLands = results.getKey();
        Map<SimpleChunkLocation, Structure> rejectedPowercellLands = results.getValue();
        if (acceptedLands.isEmpty()) {
            if (!rejectedPowercellLands.isEmpty()) {
                return context.fail(KingdomsLang.COMMAND_INVADE_POWERCELL);
            }
            throw new IllegalStateException();
        }
        if (notAdmin && !InvasionFactory.handleMaxClaims(player.getWorld(), context, kp, attackerKingdom, 1)) {
            return CommandResult.FAILED;
        }
        if (notAdmin) {
            Pair<Long, Double> costs = InvasionFactory.getInvasionCosts(player, defenderKingdom, ransack);
            long rpCost = costs.getKey();
            double money = costs.getValue();
            if (!attackerKingdom.getBank().has(money) || !attackerKingdom.getResourcePoints().has(rpCost)) {
                KingdomsLang.COMMAND_INVADE_COSTS.sendError((CommandSender)player, "rp", Numbers.toFancyNumber(rpCost), "money", Numbers.toFancyNumber(money));
                return CommandResult.FAILED;
            }
            attackerKingdom.getResourcePoints().add(-rpCost);
            attackerKingdom.getBank().add(-money);
        }
        if ((invasion = InvasionFactory.standardInvasion(land, acceptedLands, player, ransack)).isCancelled()) {
            return CommandResult.FAILED;
        }
        if (deactivateShield != null) {
            deactivateShield.run();
        }
        KingdomsLang.COMMAND_INVADE_INVADING.sendMessage((CommandSender)player, "kingdom", defenderKingdom.getName());
        if (KingdomsConfig.Invasions.COUNTDOWN_SHOW_TO_DEFENDER.getManager().getBoolean()) {
            for (Player member : defenderKingdom.getOnlineMembers()) {
                KingdomsLang.COMMAND_INVADE_INVADING_DEFENDER_NOTIFY.sendMessage((CommandSender)member, "invader", player.getName());
            }
        }
        for (Player member : attackerKingdom.getOnlineMembers()) {
            KingdomsLang.COMMAND_INVADE_ANNOUNCEMENT.sendMessage((CommandSender)member, "invader", player.getName(), "kingdom", defenderKingdom.getName(), "location", land.getLocation());
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public CommandResult execute(CommandContext context) {
        return CommandInvade.execute(context, false);
    }
}

