/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.home;

import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;

public class CommandUnsetHome
extends KingdomsCommand {
    public CommandUnsetHome() {
        super("unsethome", true);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasPermission(StandardKingdomPermission.SET_HOME)) {
            StandardKingdomPermission.SET_HOME.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        Kingdom kingdom = kp.getKingdom();
        Location home = BukkitAdapter.adapt(kingdom.getHome());
        if (home == null) {
            KingdomsLang.COMMAND_UNSETHOME_NOT_SET.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        if (kingdom.setHome(null, kp).isCancelled()) {
            return CommandResult.FAILED;
        }
        for (Player member : kingdom.getOnlineMembers()) {
            KingdomsLang.COMMAND_UNSETHOME_SUCCESS.sendMessage((CommandSender)member, "x", home.getBlockX(), "y", home.getBlockY(), "z", home.getBlockZ());
        }
        return CommandResult.SUCCESS;
    }
}

