/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.election;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.election.AbstractCommandElectionVote;
import org.kingdoms.commands.general.election.CommandElection;
import org.kingdoms.gui.pagination.GUIPagination;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.managers.daily.elections.ElectionCandidate;
import org.kingdoms.managers.daily.elections.Elections;

public class CommandElectionVote
extends AbstractCommandElectionVote {
    public CommandElectionVote(KingdomsParentCommand parent) {
        super(parent, Elections.KINGDOMS);
    }

    @Override
    protected void addCandidates(Player voter, Runnable refresh, GUIPagination<ElectionCandidate> pagination) {
        for (ElectionCandidate candidate : pagination.getPaginatedElements()) {
            OfflinePlayer memberPlayer = Bukkit.getOfflinePlayer((UUID)candidate.getId());
            pagination.getOption().setEdits("votes", candidate.getVotes().size(), "candidates-description", candidate.getStatement() != null ? candidate.getStatement() : KingdomsLang.ELECTIONS_DEFAULT_STATEMENT.parse(memberPlayer, new Object[0])).onNormalClicks(ctx -> {
                ctx.var("candidate", memberPlayer.getName());
                UUID currentVoteId = this.electionsManager.getVote(voter);
                if (currentVoteId == null) {
                    this.electionsManager.vote(voter, candidate.getId());
                    ctx.sendMessage((Messenger)KingdomsLang.COMMAND_ELECTION_VOTE_VOTED, new Object[0]);
                    refresh.run();
                } else {
                    OfflinePlayer currentVotedCandidate = Bukkit.getOfflinePlayer((UUID)currentVoteId);
                    ctx.var("previous-candidate", currentVotedCandidate.getName());
                    if (currentVotedCandidate.getUniqueId().equals(candidate.getId())) {
                        ctx.sendError(KingdomsLang.COMMAND_ELECTION_VOTE_ALREADY_VOTED, new Object[0]);
                    } else {
                        ctx.sendError(KingdomsLang.COMMAND_ELECTION_VOTE_VOTED_AGAIN, new Object[0]);
                    }
                }
            }).pushHead(memberPlayer);
        }
    }

    @Override
    protected boolean commonChecks(CommandContext context) {
        return CommandElection.checkOngoingElection(context, this.electionsManager);
    }
}

