/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.election;

import java.time.temporal.ChronoUnit;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.election.CommandElectionRegister;
import org.kingdoms.commands.general.election.CommandElectionStatement;
import org.kingdoms.commands.general.election.CommandElectionVote;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.daily.elections.ElectionsManager;
import org.kingdoms.utils.time.TimeFormatter;

public class CommandElection
extends KingdomsParentCommand {
    public CommandElection() {
        super("election", true);
        if (this.isDisabled()) {
            return;
        }
        new CommandElectionVote(this);
        new CommandElectionRegister(this);
        new CommandElectionStatement(this);
    }

    public static boolean checkOngoingElection(CommandContext context, ElectionsManager electionsManager) {
        if (electionsManager.isAcceptingVotes()) {
            context.sendError(KingdomsLang.COMMAND_ELECTION_NO_ONGOING_ELECTION, "next-election", TimeFormatter.of(electionsManager.untilNextRun(ChronoUnit.MILLIS)));
            return true;
        }
        Kingdom kingdom = context.getKingdom();
        if (kingdom != null && !ElectionsManager.isEnabledFor(kingdom)) {
            context.sendError(KingdomsLang.COMMAND_ELECTION_DISABLED_FOR_KINGDOM, new Object[0]);
            return true;
        }
        return false;
    }
}

