/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.claims.unclaiming;

import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.commands.general.claims.claiming.CommandClaim;
import org.kingdoms.commands.general.claims.unclaiming.CommandUnclaimAll;
import org.kingdoms.commands.general.claims.unclaiming.CommandUnclaimAuto;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.lands.UnclaimLandEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.land.claiming.UnclaimProcessor;
import org.kingdoms.managers.land.indicator.LandVisualizer;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.server.location.BlockVector2;

public class CommandUnclaim
extends KingdomsParentCommand {
    public CommandUnclaim() {
        super("unclaim", true);
        if (this.isDisabled()) {
            return;
        }
        new CommandUnclaimAuto(this);
        new CommandUnclaimAll(this);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        SimpleChunkLocation loc;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = context.getKingdomPlayer();
        if (context.assertArgs(2)) {
            if (!context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_UNCLAIM_CHUNK, true)) {
                KingdomsLang.COMMAND_UNCLAIM_CHUNK_PERMISSION.sendError((CommandSender)player, new Object[0]);
                return CommandResult.FAILED;
            }
            if (!context.isNumber(0)) {
                context.sendError(KingdomsLang.INVALID_NUMBER, "arg", context.arg(0));
                return CommandResult.FAILED;
            }
            if (!context.isNumber(1)) {
                context.sendError(KingdomsLang.INVALID_NUMBER, "arg", context.arg(1));
                return CommandResult.FAILED;
            }
            BlockVector2 coords = CommandClaim.getChunkCoords((CommandSender)player, context.arg(0), context.arg(1));
            if (coords == null) {
                return CommandResult.FAILED;
            }
            loc = new SimpleChunkLocation(player.getWorld().getName(), coords.getX(), coords.getZ());
        } else {
            loc = SimpleChunkLocation.of(player.getLocation());
        }
        boolean confirmed = false;
        if (context.argsLengthEquals(1) || context.assertArgs(3)) {
            confirmed = context.argsLengthEquals(1) ? context.arg(0).equalsIgnoreCase("confirm") : context.arg(2).equalsIgnoreCase("confirm");
        }
        Kingdom kingdom = kp.getKingdom();
        UnclaimProcessor processor = UnclaimProcessor.build(loc, kp, kingdom);
        processor.setConfirmed(confirmed);
        processor.process();
        if (!processor.isSuccessful()) {
            processor.sendMessages(context.getMessageReceiver());
            return CommandResult.FAILED;
        }
        Land land = loc.getLand();
        if (land.unclaim(kp, UnclaimLandEvent.Reason.UNCLAIMED).isCancelled()) {
            return CommandResult.FAILED;
        }
        processor.finalizeProcess();
        new LandVisualizer().forPlayer(player, kp).forLand(land, loc.toChunk()).displayMessages().displayIndicators();
        KingdomsLang.COMMAND_UNCLAIM_SUCCESS.sendMessage((CommandSender)player, "x", loc.getX(), "z", loc.getZ());
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            List<String> cmds = TabCompleteManager.tabCompleteSubCommands(context.getMessageReceiver(), this, context.getArgs());
            cmds.add("confirm");
            if (context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_CLAIM_CHUNK) && cmds.isEmpty() && context.isNumber(0)) {
                cmds.addAll(CommandUnclaim.tabComplete("&2<x>"));
            }
            return cmds;
        }
        if (context.isAtArg(1) && !context.arg(0).equals("confirm")) {
            return CommandUnclaim.tabComplete("&2<z>");
        }
        if (context.isAtArg(2)) {
            return CommandUnclaim.tabComplete("confirm");
        }
        return CommandUnclaim.emptyTab();
    }
}

