/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.claims.claiming;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.land.claiming.AbstractClaimProcessor;
import org.kingdoms.managers.land.claiming.ClaimClipboard;
import org.kingdoms.managers.land.claiming.ClaimProcessor;
import org.kingdoms.managers.land.claiming.bulk.BasicBulkClaimProcessor;
import org.kingdoms.managers.land.claiming.bulk.BulkClaimProcessor;
import org.kingdoms.utils.internal.functional.Fn;

public class CommandClaimSquare
extends KingdomsCommand {
    public CommandClaimSquare(KingdomsParentCommand parent) {
        super("square", parent);
    }

    public static Pair<SimpleChunkLocation, SimpleChunkLocation> getCenteredSquareCorners(SimpleChunkLocation chunk, int radius) {
        int plus = radius % 2;
        return Pair.of(chunk.getRelative(-(radius /= 2), -radius), chunk.getRelative(radius + plus, radius + plus));
    }

    public static <T extends AbstractClaimProcessor> BasicBulkClaimProcessor<T> squared(T context, SimpleChunkLocation from, SimpleChunkLocation to, boolean edgesOnly) {
        if (!from.getWorld().equals(to.getWorld())) {
            throw new IllegalArgumentException("Cannot claim a square in two unrelated worlds: " + from.getWorld() + " - " + to.getWorld());
        }
        BasicBulkClaimProcessor<T> claimProcessor = new BasicBulkClaimProcessor<T>(context);
        boolean incrementX = from.getX() < to.getX();
        boolean incrementZ = from.getZ() < to.getZ();
        int minX = Math.min(from.getX(), to.getX());
        int maxX = Math.max(from.getX(), to.getX()) - 1;
        int minZ = Math.min(from.getZ(), to.getZ());
        int maxZ = Math.max(from.getZ(), to.getZ()) - 1;
        int index = 1;
        for (int x = from.getX(); x != to.getX(); x += incrementX ? 1 : -1) {
            for (int z = from.getZ(); z != to.getZ(); z += incrementZ ? 1 : -1) {
                SimpleChunkLocation current;
                T processor;
                if (edgesOnly && x != minX && x != maxX && z != minZ && z != maxZ || !((processor = claimProcessor.addBatch(current = new SimpleChunkLocation(from.getWorld(), x, z))) instanceof ClaimProcessor)) continue;
                ((ClaimProcessor)processor).phantomClaimCount(index++);
            }
        }
        return claimProcessor;
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        int maxRadius = KingdomsConfig.Claims.SQUARE_MAX_RADIUS.getManager().getInt();
        context.var("max", maxRadius).var("radius", context.arg(0));
        if (!context.isNumber(0)) {
            context.sendError(KingdomsLang.COMMAND_CLAIM_SQUARE_RADIUS_INVALID, new Object[0]);
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = context.getKingdomPlayer();
        int radius = context.intArg(0);
        if (!(kp.isAdmin() || radius >= 2 && radius <= maxRadius)) {
            context.sendError(KingdomsLang.COMMAND_CLAIM_SQUARE_RADIUS_DISALLOWED, new Object[0]);
            return CommandResult.FAILED;
        }
        boolean edgesOnly = context.assertArgs(2);
        if (edgesOnly) {
            Boolean snd = context.parseBool(1);
            if (snd == null) {
                return CommandResult.FAILED;
            }
            edgesOnly = snd;
        }
        Kingdom kingdom = kp.getKingdom();
        Messenger constantIssue = ClaimProcessor.build(SimpleChunkLocation.of(player.getLocation()), kp, kingdom).checkWorldAndPermission();
        if (constantIssue != null) {
            context.sendError(constantIssue, new Object[0]);
            return CommandResult.FAILED;
        }
        boolean finalEdgesOnly = edgesOnly;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.get(), () -> {
            SimpleChunkLocation chunk = SimpleChunkLocation.of(player.getLocation());
            Pair<SimpleChunkLocation, SimpleChunkLocation> corners = CommandClaimSquare.getCenteredSquareCorners(chunk, radius);
            BasicBulkClaimProcessor<ClaimProcessor> result = CommandClaimSquare.squared(ClaimProcessor.build(chunk, kp, kingdom), corners.getKey(), corners.getValue(), finalEdgesOnly);
            ClaimClipboard.addClipboard(player, new Clipboard(player.getWorld(), (BulkClaimProcessor)Fn.cast(result), radius));
            kp.buildMap().clipboardMode().display();
            KingdomsLang.COMMAND_CLAIM_SQUARE_DONE.sendMessage((CommandSender)player);
        });
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        if (context.isAtArg(0)) {
            return CommandClaimSquare.tabComplete("&2<radius>");
        }
        return CommandClaimSquare.emptyTab();
    }

    public static final class Clipboard
    extends ClaimClipboard {
        private final int radius;

        public Clipboard(World world, BulkClaimProcessor claims, int radius) {
            super(world, claims);
            this.radius = radius;
        }

        public int getRadius() {
            return this.radius;
        }
    }
}

