/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.claims.claiming;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Pair;
import org.kingdoms.libs.kotlin.TuplesKt;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.collections.MapsKt;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.functions.Function2;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.ranges.RangesKt;
import org.kingdoms.locale.HoverMessage;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.locale.provider.MessageProvider;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.utils.KingdomsBukkitExtensions;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.internal.numbers.RomanNumber;
import org.kingdoms.utils.string.tree.DefaultStringTreeSettings;
import org.kingdoms.utils.string.tree.TreeBuilder;
import org.kingdoms.utils.string.tree.TreeStyle;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/kingdoms/commands/general/claims/claiming/CommandClaimList;", "Lorg/kingdoms/commands/KingdomsCommand;", "parent", "Lorg/kingdoms/commands/KingdomsParentCommand;", "<init>", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "tabComplete", "", "", "Lorg/kingdoms/commands/CommandTabContext;", "core"})
@SourceDebugExtension(value={"SMAP\nCommandClaimList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandClaimList.kt\norg/kingdoms/commands/general/claims/claiming/CommandClaimList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KingdomsBukkitExtensions.kt\norg/kingdoms/utils/KingdomsBukkitExtensions\n*L\n1#1,120:1\n1187#2,2:121\n1261#2,4:123\n39#3:127\n*S KotlinDebug\n*F\n+ 1 CommandClaimList.kt\norg/kingdoms/commands/general/claims/claiming/CommandClaimList\n*L\n56#1:121,2\n56#1:123,4\n87#1:127\n*E\n"})
public final class CommandClaimList
extends KingdomsCommand {
    public CommandClaimList(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("list", parent);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        void $this$associateTo$iv$iv;
        Kingdom kingdom;
        Kingdom kingdom2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        if (context.assertArgs(1)) {
            if (!context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_CLAIM_LIST_OTHERS)) {
                CommandResult commandResult = context.fail(KingdomsLang.COMMAND_CLAIM_LIST_OTHERS_PERMISSION);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
                return commandResult;
            }
            kingdom2 = context.getKingdom(0);
            Intrinsics.checkNotNull((Object)kingdom2);
            kingdom = kingdom2;
        } else {
            kingdom2 = context.getKingdom();
            Intrinsics.checkNotNull((Object)kingdom2);
            kingdom = kingdom2;
        }
        Kingdom kingdom3 = kingdom;
        Map mappedLands = new HashMap();
        for (SimpleChunkLocation location : kingdom3.getLandLocations()) {
            mappedLands.compute(location.getWorld(), (arg_0, arg_1) -> CommandClaimList.execute$lambda$1((arg_0, arg_1) -> CommandClaimList.execute$lambda$0(location, arg_0, arg_1), arg_0, arg_1));
        }
        if (mappedLands.isEmpty()) {
            context.sendError(KingdomsLang.COMMAND_CLAIM_LIST_NO_CLAIMS, new Object[0]);
            return CommandResult.FAILED;
        }
        Comparator comparator = ((Comparator)CommandClaimList::execute$lambda$2).thenComparing((arg_0, arg_1) -> CommandClaimList.execute$lambda$4(CommandClaimList::execute$lambda$3, arg_0, arg_1));
        String ownColor = KingdomsLang.COMMAND_CLAIM_LIST_OWN_COLOR.parse(context.getMessageContext());
        boolean allowTp = context.hasPermission(KingdomsDefaultPluginPermission.TELEPORT_TO_CLAIMS);
        KingdomPlayer kp = context.isPlayer() ? context.getKingdomPlayer() : null;
        Iterable $this$associate$iv = mappedLands.entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            MessageProvider messageProvider = LocationUtils.translateWorld((String)it.getKey()).getProvider(context.getMessageContext().getLanguage());
            Intrinsics.checkNotNull((Object)messageProvider);
            MessageObject messageObject = messageProvider.getMessage();
            Intrinsics.checkNotNull((Object)messageObject);
            Pair pair = TuplesKt.to((Object)messageObject.buildPlain(context.getMessageContext()), ((List)it.getValue()).stream().sorted(comparator).map(arg_0 -> CommandClaimList.execute$lambda$7$lambda$6(arg_0 -> CommandClaimList.execute$lambda$7$lambda$5(kp, ownColor, allowTp, context, arg_0), arg_0)).collect(Collectors.toList()));
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map tree = destination$iv$iv;
        TreeStyle style = DefaultStringTreeSettings.INSTANCE.generateTreeStyle(true, 4);
        Iterator<StringBuilder> iterator = new TreeBuilder(tree).parse(style).print().getLines().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<StringBuilder> iterator2 = iterator;
        while (iterator2.hasNext()) {
            StringBuilder line;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            context.sendMessage((Messenger)new StaticMessenger(new MessageProvider(MessageCompiler.compile(line.toString(), DefaultStringTreeSettings.COMPILER_SETTINGS))), new Object[0]);
        }
        return CommandResult.SUCCESS;
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandTabContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_CLAIM_LIST_OTHERS) && context.isAtArg(0)) {
            List<String> list = context.getKingdoms(0);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getKingdoms(...)");
            return list;
        }
        List<String> list = context.emptyTab();
        Intrinsics.checkNotNullExpressionValue(list, (String)"emptyTab(...)");
        return list;
    }

    private static final List execute$lambda$0(SimpleChunkLocation $location, String string, List v) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        List list = v;
        if (list == null) {
            list = new ArrayList();
        }
        List list2 = list;
        Intrinsics.checkNotNull((Object)$location);
        list2.add($location);
        return list2;
    }

    private static final List execute$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (List)$tmp0.invoke(p0, p1);
    }

    private static final int execute$lambda$2(SimpleChunkLocation o1, SimpleChunkLocation o2) {
        Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        return Intrinsics.compare((int)o1.getX(), (int)o2.getX());
    }

    private static final int execute$lambda$3(SimpleChunkLocation o1, SimpleChunkLocation o2) {
        Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        return Intrinsics.compare((int)o1.getZ(), (int)o2.getZ());
    }

    private static final int execute$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    /*
     * Unable to fully structure code
     */
    private static final String execute$lambda$7$lambda$5(KingdomPlayer $kp, String $ownColor, boolean $allowTp, CommandContext $context, SimpleChunkLocation land) {
        v0 = land.getLand();
        Intrinsics.checkNotNull((Object)v0);
        landData = v0;
        turrets = landData.getTurrets().size();
        if (landData.getStructures().size() != 1) {
            v1 = landData.getStructures().isEmpty() ? "{$$none}" : Integer.valueOf(landData.getStructures().size());
        } else {
            structure = (Structure)CollectionsKt.first((Iterable)landData.getStructures().values());
            v1 = structure.getDisplayName() + " {$sep}({$s}" + RomanNumber.toRoman(structure.getLevel()) + "{$sep})";
        }
        structures = v1;
        v2 = $kp;
        ownsLand = v2 != null && (v2 = v2.getClaims()) != null ? v2.contains(land) : false;
        ownColorize = ownsLand != false ? $ownColor : "{$p}";
        str = ownColorize + land.getX() + "&7, " + ownColorize + land.getZ();
        v3 = action = $allowTp != false ? "/k admin land " + land.getWorld() + ' ' + land.getX() + ' ' + land.getZ() : "";
        description = $allowTp != false ? KingdomsLang.COMMAND_CLAIM_LIST_TELEPORT_ADMIN_DESCRIPTION : (ownsLand != false ? KingdomsLang.COMMAND_CLAIM_LIST_LAND_OWNER : KingdomsLang.COMMAND_CLAIM_LIST_TELEPORT_DESCRIPTION);
        v4 = $context.getMessageReceiver();
        var13_14 = new Object[6];
        var13_14[0] = "turrets";
        var13_14[1] = turrets;
        var13_14[2] = "structures";
        var13_14[3] = structures;
        var13_14[4] = "claimedBy";
        var14_15 = landData.getClaimedBy();
        if (var14_15 == null) ** GOTO lbl-1000
        var16_16 = KingdomsBukkitExtensions.INSTANCE;
        $this$asOfflinePlayer$iv = var14_15;
        $i$f$asOfflinePlayer = false;
        v5 = Bukkit.getOfflinePlayer((UUID)$this$asOfflinePlayer$iv);
        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getOfflinePlayer(...)");
        var15_19 = v5;
        if (var15_19 != null && (var16_16 = var15_19.getName()) != null) {
            v6 = var16_16;
        } else lbl-1000:
        // 2 sources

        {
            v6 = KingdomsLang.NONE;
        }
        var13_14[5] = v6;
        str = new HoverMessage(str, description.parse(v4, var13_14), action).toString();
        return str;
    }

    private static final String execute$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

