/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.claims.claiming;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.land.claiming.AbstractClaimProcessor;
import org.kingdoms.managers.land.claiming.ClaimClipboard;
import org.kingdoms.managers.land.claiming.UnclaimProcessor;
import org.kingdoms.managers.land.claiming.bulk.BasicBulkClaimProcessor;
import org.kingdoms.managers.land.claiming.bulk.BulkClaimProcessor;
import org.kingdoms.utils.Compass;

public class CommandClaimLine
extends KingdomsCommand {
    public CommandClaimLine(KingdomsParentCommand parent) {
        super("line", parent);
    }

    public static <T extends AbstractClaimProcessor> BulkClaimProcessor claimLine(T context, SimpleChunkLocation chunk, Compass direction, int distance) {
        BasicBulkClaimProcessor<T> processor = new BasicBulkClaimProcessor<T>(context);
        processor.addBatch(chunk);
        BlockFace facing = direction.toBlockFace();
        for (int i = 0; i <= distance; ++i) {
            chunk = chunk.getRelative(facing.getModX(), facing.getModZ());
            processor.addBatch(chunk);
        }
        return processor;
    }

    @Override
    public CommandResult execute(CommandContext context) {
        return CommandClaimLine.commons(context, true);
    }

    public static CommandResult commons(CommandContext context, boolean claiming) {
        Compass facing;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        if (!context.isNumber(0)) {
            context.sendError(KingdomsLang.INVALID_NUMBER, "arg", context.arg(0));
            return CommandResult.FAILED;
        }
        int maxDistance = KingdomsConfig.Claims.LINE_MAX_DISTANCE.getManager().getInt();
        int distance = context.intArg(0);
        if (distance < 2) {
            context.sendError(KingdomsLang.COMMAND_CLAIM_LINE_MIN_DISTANCE, "min", 2, "distance", distance);
            return CommandResult.FAILED;
        }
        if (distance > maxDistance) {
            context.sendError(KingdomsLang.COMMAND_CLAIM_LINE_MAX_DISTANCE, "max", maxDistance, "distance", distance);
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = context.getKingdomPlayer();
        Kingdom kingdom = kp.getKingdom();
        if (context.assertArgs(2)) {
            String direction = context.joinArgs("_", 1);
            Optional<Compass> found = Compass.getCardinalDirection(kp, direction.toLowerCase());
            if (!found.isPresent()) {
                context.sendError(KingdomsLang.COMMAND_CLAIM_LINE_INVALID_DIRECTION, "direction", direction);
                return CommandResult.FAILED;
            }
            facing = found.get();
        } else {
            facing = Compass.getCardinalDirection((Entity)player);
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.get(), () -> {
            SimpleChunkLocation chunk = SimpleChunkLocation.of(player.getLocation());
            AbstractClaimProcessor ctx = claiming ? new ClaimClipboard.ClaimProcessor(chunk, kp, kingdom) : UnclaimProcessor.build(chunk, kp, kingdom);
            BulkClaimProcessor claims = CommandClaimLine.claimLine(ctx, chunk, facing, distance);
            ClaimClipboard.addClipboard(player, new Clipboard(player.getWorld(), claims, facing));
            kp.buildMap().clipboardMode().display();
            context.var("direction", facing.getLanguage());
            context.var("lands", claims.getProcessedClaims().size());
            context.sendMessage((Messenger)(claiming ? KingdomsLang.COMMAND_CLAIM_LINE_DONE : KingdomsLang.COMMAND_UNCLAIM_LINE_DONE), new Object[0]);
        });
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            return CommandClaimLine.tabComplete("<distance>");
        }
        if (context.isAtArg(1)) {
            List<String> directions = Arrays.stream(Compass.CARDINAL_DIRECTIONS).map(x -> x.getLanguage().parse(context.getMessageReceiver(), new Object[0])).collect(Collectors.toList());
            return context.suggest(1, directions);
        }
        return CommandClaimLine.emptyTab();
    }

    public static final class Clipboard
    extends ClaimClipboard {
        private final Compass direction;

        public Clipboard(World world, BulkClaimProcessor claims, Compass direction) {
            super(world, claims);
            this.direction = direction;
        }
    }
}

