/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.claims.claiming;

import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.land.claiming.AbstractClaimProcessor;
import org.kingdoms.managers.land.claiming.ClaimClipboard;
import org.kingdoms.managers.land.claiming.UnclaimProcessor;
import org.kingdoms.managers.land.claiming.bulk.BasicBulkClaimProcessor;
import org.kingdoms.managers.land.claiming.bulk.BulkClaimProcessor;
import org.kingdoms.scheduler.TaskThreadType;

public class CommandClaimFill
extends KingdomsCommand {
    public CommandClaimFill(KingdomsParentCommand parent) {
        super("fill", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        boolean claiming = true;
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        SimpleChunkLocation chunk = SimpleChunkLocation.of(player.getLocation());
        Land masterLand = chunk.getLand();
        if (masterLand != null && masterLand.isClaimed()) {
            KingdomsLang.COMMAND_CLAIM_FILL_IN_CLAIMED_LAND.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        Kingdoms.taskScheduler().run(TaskThreadType.ASYNC, () -> {
            UnclaimProcessor ctx = claiming ? new ClaimClipboard.ClaimProcessor(chunk, kp, kingdom).dontCheckConnections() : UnclaimProcessor.build(chunk, kp, kingdom);
            FloodFill<UnclaimProcessor> ff = new FloodFill<UnclaimProcessor>(ctx, kingdom, kp, chunk);
            if (context.assertArgs(1) && context.isAdmin()) {
                Integer limit = context.getInt(0);
                if (limit == null) {
                    return;
                }
                ff.maxIterations = limit;
            }
            Messenger error = ((FloodFill)ff).fill();
            ClaimClipboard.addClipboard(player, new Clipboard(player.getWorld(), ff));
            kp.buildMap().clipboardMode().display();
            if (error != null) {
                context.sendError(error, "lands", ((FloodFill)ff).maxClaims);
            } else {
                context.sendMessage((Messenger)KingdomsLang.COMMAND_CLAIM_FILL_DONE, new Object[0]);
            }
        });
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        if (context.isAtArg(0) && context.isAdmin()) {
            return context.tabComplete((Messenger)KingdomsLang.COMMAND_CLAIM_FILL_TAB_LIMIT);
        }
        return context.emptyTab();
    }

    private static final class FloodFill<T extends AbstractClaimProcessor>
    extends BasicBulkClaimProcessor<T> {
        private final Kingdom kingdom;
        private final KingdomPlayer kp;
        private final int chunksLimit;
        public int maxIterations = KingdomsConfig.Claims.FILL_MAX_ITERATIONS.getManager().getInt();
        private final SimpleChunkLocation mainChunk;
        private final Queue<SimpleChunkLocation> groups = new LinkedList<SimpleChunkLocation>();
        private final int maxClaims;

        public FloodFill(T context, Kingdom kingdom, KingdomPlayer kp, SimpleChunkLocation mainChunk) {
            super(context);
            this.kingdom = kingdom;
            this.kp = kp;
            this.mainChunk = mainChunk;
            this.chunksLimit = KingdomsConfig.Claims.FILL_MAX_CLAIMS.getManager().getInt();
            this.addBatch(mainChunk);
            if (kp.isAdmin()) {
                this.maxClaims = Integer.MAX_VALUE;
            } else {
                int rankMaxClaims = kp.getRank().getMaxClaims();
                int kingdomMaxLands = kingdom.getMaxClaims(mainChunk.getWorld());
                int leftKingdomClaims = Math.max(0, kingdomMaxLands - kingdom.getLandLocations().size());
                this.maxClaims = rankMaxClaims > 0 ? Math.min(Math.max(0, rankMaxClaims - kp.getClaims().size()), leftKingdomClaims) : leftKingdomClaims;
            }
        }

        private Messenger fill() {
            if (this.maxClaims <= 0) {
                return KingdomsLang.COMMAND_CLAIM_FILL_MAX_CLAIMS;
            }
            int iterationCount = -10;
            if (!this.computeChunk(this.mainChunk)) {
                return KingdomsLang.COMMAND_CLAIM_FILL_MAX_CLAIMS;
            }
            while (!this.groups.isEmpty()) {
                if (iterationCount > this.maxIterations) {
                    return KingdomsLang.COMMAND_CLAIM_FILL_MAX_ITERATIONS;
                }
                SimpleChunkLocation next = this.groups.poll();
                if (next == null) {
                    return null;
                }
                if (!this.computeChunk(next)) {
                    return KingdomsLang.COMMAND_CLAIM_FILL_MAX_CLAIMS;
                }
                ++iterationCount;
            }
            return null;
        }

        private boolean computeChunk(SimpleChunkLocation around) {
            SimpleChunkLocation mono = around.getRelative(1, 0);
            SimpleChunkLocation di = around.getRelative(-1, 0);
            SimpleChunkLocation tri = around.getRelative(0, 1);
            SimpleChunkLocation tetra = around.getRelative(0, -1);
            for (SimpleChunkLocation chunk : new SimpleChunkLocation[]{mono, di, tri, tetra}) {
                Land land;
                if (!this.kp.isAdmin() && this.getClaims().size() >= this.maxClaims) {
                    return false;
                }
                if (this.isProcessed(chunk) || (land = chunk.getLand()) != null && land.isClaimed()) continue;
                this.addBatch(chunk);
                this.groups.add(chunk);
            }
            return true;
        }
    }

    public static final class Clipboard
    extends ClaimClipboard {
        public Clipboard(World world, BulkClaimProcessor claims) {
            super(world, claims);
        }
    }
}

