/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.claims.claiming;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.claims.claiming.CommandClaimSquare;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.managers.land.claiming.ClaimClipboard;
import org.kingdoms.managers.land.claiming.ClaimProcessor;
import org.kingdoms.managers.land.claiming.bulk.BasicBulkClaimProcessor;
import org.kingdoms.managers.land.claiming.bulk.BulkClaimProcessor;

public class CommandClaimCorner
extends KingdomsCommand {
    private static final Map<UUID, Pair<SimpleLocation, SimpleLocation>> CORNERS = new HashMap<UUID, Pair<SimpleLocation, SimpleLocation>>();

    public CommandClaimCorner(KingdomsParentCommand parent) {
        super("corner", parent);
    }

    public static Map<UUID, Pair<SimpleLocation, SimpleLocation>> getCorners() {
        return CORNERS;
    }

    @Override
    public CommandResult execute(CommandContext context) {
        SimpleLocation pos2;
        SimpleLocation pos1;
        boolean first;
        String arg;
        boolean exists;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = context.getKingdomPlayer();
        Kingdom kingdom = kp.getKingdom();
        Pair<SimpleLocation, SimpleLocation> corners = CORNERS.get(player.getUniqueId());
        boolean bl = exists = corners != null;
        if (!exists) {
            corners = Pair.empty();
        }
        if ((arg = context.arg(0)).equalsIgnoreCase("pos1")) {
            first = true;
        } else if (arg.equalsIgnoreCase("pos2")) {
            first = false;
        } else {
            context.wrongUsage();
            return CommandResult.FAILED;
        }
        SimpleLocation currentLocation = SimpleLocation.of(player.getLocation());
        if (first) {
            pos1 = currentLocation;
            pos2 = corners.getValue();
        } else {
            pos1 = corners.getKey();
            pos2 = currentLocation;
        }
        corners.setKey(pos1);
        corners.setValue(pos2);
        if (!exists) {
            CORNERS.put(player.getUniqueId(), corners);
        }
        if (pos1 == null || pos2 == null) {
            SimpleChunkLocation pos1Chunk = pos1 == null ? null : pos1.toSimpleChunkLocation();
            SimpleChunkLocation pos2Chunk = pos2 == null ? null : pos2.toSimpleChunkLocation();
            context.sendMessage((Messenger)(first ? KingdomsLang.COMMAND_CLAIM_CORNER_SET_POS1 : KingdomsLang.COMMAND_CLAIM_CORNER_SET_POS2), "x1", pos1 == null ? 126 : pos1.getX(), "y1", pos1 == null ? 126 : pos1.getY(), "z1", pos1 == null ? 126 : pos1.getZ(), "chunkX1", pos1Chunk == null ? 126 : pos1Chunk.getX(), "chunkZ1", pos1Chunk == null ? 126 : pos1Chunk.getZ(), "x2", pos2 == null ? 126 : pos2.getX(), "y2", pos2 == null ? 126 : pos2.getY(), "z2", pos2 == null ? 126 : pos2.getZ(), "chunkX2", pos2Chunk == null ? 126 : pos2Chunk.getX(), "chunkZ2", pos2Chunk == null ? 126 : pos2Chunk.getZ());
            return CommandResult.FAILED;
        }
        BasicBulkClaimProcessor<ClaimProcessor> claims = CommandClaimSquare.squared(ClaimProcessor.build(pos1.toSimpleChunkLocation(), kp, kingdom), pos1.toSimpleChunkLocation(), pos2.toSimpleChunkLocation(), false);
        ClaimClipboard.addClipboard(player, new Clipboard(player.getWorld(), claims, corners));
        kp.buildMap().clipboardMode().display();
        SimpleChunkLocation pos1Chunk = pos1.toSimpleChunkLocation();
        SimpleChunkLocation pos2Chunk = pos2.toSimpleChunkLocation();
        context.sendMessage((Messenger)(first ? KingdomsLang.COMMAND_CLAIM_CORNER_SET_POS1 : KingdomsLang.COMMAND_CLAIM_CORNER_SET_POS2), "x1", pos1.getX(), "y1", pos1.getY(), "z1", pos1.getZ(), "chunkX1", pos1Chunk.getX(), "chunkZ1", pos1Chunk.getZ(), "x2", pos2.getX(), "y2", pos2.getY(), "z2", pos2.getZ(), "chunkX2", pos2Chunk.getX(), "chunkZ2", pos2Chunk.getZ());
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            return CommandClaimCorner.tabComplete("pos1", "pos2");
        }
        return CommandClaimCorner.emptyTab();
    }

    public static final class Clipboard
    extends ClaimClipboard {
        private final Pair<SimpleLocation, SimpleLocation> corners;

        public Clipboard(World world, BulkClaimProcessor claims, Pair<SimpleLocation, SimpleLocation> corners) {
            super(world, claims);
            this.corners = corners;
        }

        public Pair<SimpleLocation, SimpleLocation> getCorners() {
            return this.corners;
        }
    }
}

