/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.claims.claiming;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.claims.claiming.CommandClaim;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.managers.land.claiming.ClaimClipboard;
import org.kingdoms.managers.land.claiming.ClaimProcessor;
import org.kingdoms.server.location.BlockVector2;
import org.kingdoms.utils.internal.numbers.Numbers;

public class CommandClaimClipboard
extends KingdomsCommand {
    public CommandClaimClipboard(KingdomsParentCommand parent) {
        super("clipboard", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        Action action;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        ClaimClipboard session = ClaimClipboard.getClipboards().get(player.getUniqueId());
        if (session == null) {
            context.sendError(KingdomsLang.COMMAND_CLAIM_CLIPBOARD_EMPTY, new Object[0]);
            return CommandResult.FAILED;
        }
        if (!session.getWorld().getUID().equals(player.getWorld().getUID())) {
            context.sendError(KingdomsLang.COMMAND_CLAIM_CLIPBOARD_DIFFERENT_WORLD, "world", player.getWorld().getName());
            return CommandResult.FAILED;
        }
        if (context.assertArgs(1)) {
            try {
                action = Action.valueOf(context.arg(0).toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException ex) {
                context.sendError(KingdomsLang.COMMAND_CLAIM_CLIPBOARD_UNKNOWN_ACTION, "action", context.arg(0));
                return CommandResult.FAILED;
            }
        } else {
            action = null;
        }
        if (action != null && action != Action.CLEAR && !context.assertArgs(3)) {
            context.sendError(KingdomsLang.COMMAND_CLAIM_CLIPBOARD_USAGE, new Object[0]);
            return CommandResult.FAILED;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = Objects.requireNonNull(kp.getKingdom(), () -> "Player without a kingdom has a clipboard: " + player.getName());
        if (!kp.hasPermission(StandardKingdomPermission.CLAIM)) {
            StandardKingdomPermission.CLAIM.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)context.getPlugin(), () -> {
            kp.buildMap().clipboardMode().display();
            Pair<Long, Double> costs = session.getTotalCost();
            context.sendMessage((Messenger)KingdomsLang.COMMAND_CLAIM_CLIPBOARD_COST, "rp", Numbers.toFancyNumber(costs.getKey().longValue()), "money", Numbers.toFancyNumber(costs.getValue()));
        });
        if (action == null) {
            return CommandResult.FAILED;
        }
        if (action == Action.CLEAR) {
            ClaimClipboard.getClipboards().remove(player.getUniqueId());
            KingdomsLang.COMMAND_CLAIM_CLIPBOARD_CLEARED.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        BlockVector2 coords = CommandClaim.getChunkCoords((CommandSender)player, context.arg(1), context.arg(2));
        if (coords == null) {
            return CommandResult.FAILED;
        }
        SimpleChunkLocation chunk = new SimpleChunkLocation(session.getWorld().getName(), coords.getX(), coords.getZ());
        context.var("x", coords.getX()).var("z", coords.getZ());
        switch (action.ordinal()) {
            case 0: {
                if (session.getClaims().getProcessedClaims().containsKey(chunk.worldlessWrapper())) {
                    context.sendError(KingdomsLang.COMMAND_CLAIM_CLIPBOARD_ALREADY_ADDED, new Object[0]);
                    break;
                }
                ClaimProcessor result = ClaimProcessor.build(chunk, kp, kingdom).process();
                if (result.isSuccessful()) {
                    context.sendMessage((Messenger)KingdomsLang.COMMAND_CLAIM_CLIPBOARD_ADDED, new Object[0]);
                    break;
                }
                result.sendMessages((CommandSender)player);
                break;
            }
            case 1: {
                if (session.getClaims().getProcessedClaims().remove(coords) != null) {
                    context.sendMessage((Messenger)KingdomsLang.COMMAND_CLAIM_CLIPBOARD_REMOVED, new Object[0]);
                    break;
                }
                context.sendError(KingdomsLang.COMMAND_CLAIM_CLIPBOARD_NOT_FOUMD, new Object[0]);
            }
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        if (context.isAtArg(0)) {
            return CommandClaimClipboard.tabComplete("add", "remove", "clear");
        }
        if (context.args.length > 1 && !context.arg(0).equalsIgnoreCase("clear")) {
            if (context.isAtArg(1) && !context.arg(0).equalsIgnoreCase("clear")) {
                return CommandClaimClipboard.tabComplete("&2<x> <z>");
            }
            if (context.isAtArg(2) && !context.arg(0).equalsIgnoreCase("clear")) {
                return CommandClaimClipboard.tabComplete("&2<z>");
            }
        }
        return CommandClaimClipboard.emptyTab();
    }

    private static enum Action {
        ADD,
        REMOVE,
        CLEAR;

    }
}

