/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.claims.claiming;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.Configs;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;

public class CommandClaimAuto
extends KingdomsCommand {
    protected static final HashMap<UUID, Integer> ACTIONBAR = new HashMap();

    public CommandClaimAuto(KingdomsParentCommand parent) {
        super("auto", parent);
    }

    public static boolean cancelActionBar(Player target) {
        Integer task = ACTIONBAR.remove(target.getUniqueId());
        if (task != null) {
            Bukkit.getScheduler().cancelTask(task.intValue());
        }
        return task != null;
    }

    public static void actionBar(final Player player, final KingdomsLang actionbar) {
        if (KingdomsConfig.Claims.ACTIONBAR_KEEP.getManager().getBoolean()) {
            int task = new BukkitRunnable(){

                public void run() {
                    if (player.isOnline()) {
                        actionbar.sendMessage((CommandSender)player);
                    } else {
                        ACTIONBAR.remove(player.getUniqueId());
                        this.cancel();
                    }
                }
            }.runTaskTimerAsynchronously((Plugin)plugin, 0L, 40L).getTaskId();
            ACTIONBAR.put(player.getUniqueId(), task);
        } else {
            actionbar.sendMessage((CommandSender)player);
        }
    }

    public static Player getTarget(CommandContext context, KingdomsDefaultPluginPermission othersPermission) {
        Player target;
        if (context.assertArgs(1)) {
            if (!context.hasPermission(othersPermission)) {
                context.sendError(KingdomsLang.COMMAND_CLAIM_AUTO_PERMISSION, new Object[0]);
                return null;
            }
            target = context.getPlayer(0);
            if (target == null) {
                return null;
            }
            context.var("target", target.getName());
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)target);
            if (!kp.hasKingdom()) {
                context.sendError(KingdomsLang.NOT_FOUND_PLAYER_NO_KINGDOM, new Object[0]);
                return null;
            }
        } else {
            if (!context.isPlayer()) {
                context.wrongUsage();
                return null;
            }
            target = context.senderAsPlayer();
            if (context.assertHasKingdom()) {
                return null;
            }
        }
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)target, KingdomsLang.DISABLED_WORLD)) {
            return null;
        }
        if (Configs.isInDisabledWorld(KingdomsConfig.Claims.DISABLED_WORLDS.getManager(), target, KingdomsLang.COMMAND_CLAIM_DISABLED_WORLD)) {
            return null;
        }
        return target;
    }

    @Override
    public CommandResult execute(CommandContext context) {
        Player target = CommandClaimAuto.getTarget(context, KingdomsDefaultPluginPermission.COMMAND_CLAIM_AUTO_OTHERS);
        if (target == null) {
            return CommandResult.FAILED;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)target);
        if (!kp.hasPermission(StandardKingdomPermission.CLAIM)) {
            StandardKingdomPermission.CLAIM.sendDeniedMessage(target);
            return CommandResult.FAILED;
        }
        boolean wasAutoClaiming = kp.getAutoClaim() == Boolean.TRUE;
        kp.setAutoClaim(wasAutoClaiming ? null : Boolean.valueOf(true));
        KingdomsLang activation = wasAutoClaiming ? KingdomsLang.COMMAND_CLAIM_AUTO_OFF : KingdomsLang.COMMAND_CLAIM_AUTO_ON;
        activation.sendMessage((CommandSender)target);
        if (wasAutoClaiming) {
            if (CommandClaimAuto.cancelActionBar(target)) {
                KingdomsLang.AUTO_CLAIM_ACTIONBAR_DISABLED.sendMessage((CommandSender)target);
            }
        } else {
            CommandClaimAuto.cancelActionBar(target);
            if (KingdomsConfig.Claims.ACTIONBAR_AUTO_CLAIM.getManager().getBoolean()) {
                CommandClaimAuto.actionBar(target, KingdomsLang.AUTO_CLAIM_ACTIONBAR_ENABLED);
            }
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.assertArgs(1) && context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_CLAIM_AUTO_OTHERS)) {
            return context.getPlayers(0);
        }
        return CommandClaimAuto.emptyTab();
    }
}

