/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.chat;

import java.util.List;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.KingdomsChatChannel;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;

public class CommandUnmute
extends KingdomsCommand {
    public CommandUnmute() {
        super("unmute", true);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        KingdomPlayer kp = context.getKingdomPlayer();
        String channelName = context.arg(0);
        KingdomsChatChannel channel = KingdomsChatChannel.getChannelUserFriendly(channelName, context.getMessageContext());
        context.var("channel", channelName);
        if (channel == null) {
            context.sendError(KingdomsLang.COMMAND_CHAT_UNKNOWN_CHANNEL, new Object[0]);
            return CommandResult.FAILED;
        }
        if (!kp.getMutedChannels().contains(channel.getDataId())) {
            context.sendError(KingdomsLang.COMMAND_UNMUTE_NOT_MUTED, new Object[0]);
            return CommandResult.FAILED;
        }
        kp.getMutedChannels().remove(channel.getDataId());
        context.sendMessage((Messenger)KingdomsLang.COMMAND_UNMUTE_UNMUTED, new Object[0]);
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (!context.isPlayer()) {
            return CommandUnmute.emptyTab();
        }
        KingdomPlayer kp = context.getKingdomPlayer();
        return context.getChannels(0, x -> !kp.getMutedChannels().contains(x.getDataId()));
    }
}

