/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.building;

import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.building.CommandBuilding;
import org.kingdoms.constants.land.KingdomBlock;
import org.kingdoms.constants.land.KingdomBuildingHandler;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.managers.land.KingdomBuildingManager;
import org.kingdoms.managers.land.block.KingdomsBlockContext;
import org.kingdoms.managers.land.block.KingdomsBlockUpgradeContext;
import org.kingdoms.utils.display.visualizer.StructureVisualizer;
import org.kingdoms.utils.internal.functional.Fn;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/kingdoms/commands/general/building/CommandBuildingUpgrade;", "Lorg/kingdoms/commands/KingdomsCommand;", "parent", "Lorg/kingdoms/commands/KingdomsParentCommand;", "<init>", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "core"})
@SourceDebugExtension(value={"SMAP\nCommandBuildingCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandBuildingCommands.kt\norg/kingdoms/commands/general/building/CommandBuildingUpgrade\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public final class CommandBuildingUpgrade
extends KingdomsCommand {
    public CommandBuildingUpgrade(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("upgrade", parent, PermissionDefault.TRUE);
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        KingdomsBlockUpgradeContext<KingdomBlock> kingdomsBlockUpgradeContext;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        KingdomBlock kingdomBlock = CommandBuilding.Companion.getKingdomBlock(context);
        if (kingdomBlock == null) {
            return CommandResult.FAILED;
        }
        KingdomBlock kingdomBlock2 = kingdomBlock;
        Player player = context.senderAsPlayer();
        KingdomPlayer kingdomPlayer = context.getKingdomPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)kingdomPlayer, (String)"getKingdomPlayer(...)");
        KingdomsBlockUpgradeContext<KingdomBlock> $this$execute_u24lambda_u240 = kingdomsBlockUpgradeContext = new KingdomsBlockUpgradeContext<KingdomBlock>(kingdomPlayer, kingdomBlock2, ((KingdomBuilding)kingdomBlock2).getLevel());
        boolean bl = false;
        ((Map)$this$execute_u24lambda_u240.getMetadata()).put(KingdomsBlockContext.DefaultMetadatas.CONFIRMATION, true);
        KingdomsBlockUpgradeContext<KingdomBlock> kingdomBlockContext = kingdomsBlockUpgradeContext;
        KingdomBuildingHandler<?> kingdomBuildingHandler = ((KingdomBuilding)kingdomBlock2).getKingdomBlockHandler();
        Object t = Fn.cast(kingdomBlockContext);
        Intrinsics.checkNotNullExpressionValue(t, (String)"cast(...)");
        Messenger messenger = kingdomBuildingHandler.onUpgrade((KingdomsBlockUpgradeContext)t);
        if (messenger != null) {
            Messenger it = messenger;
            boolean bl2 = false;
            kingdomBlockContext.fail(it);
        }
        if (!kingdomBlockContext.isSuccessful()) {
            CommandSender commandSender = context.getMessageReceiver();
            Intrinsics.checkNotNullExpressionValue((Object)commandSender, (String)"getMessageReceiver(...)");
            kingdomBlockContext.sendMessages(commandSender);
            return CommandResult.FAILED;
        }
        kingdomBlockContext.finalizeProcess();
        Intrinsics.checkNotNull((Object)player);
        Namespace namespace = KingdomBuildingManager.PREVIEW_NS;
        Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"PREVIEW_NS");
        StructureVisualizer.Companion.stop(player, namespace);
        return CommandResult.SUCCESS;
    }
}

