/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.building;

import java.util.Map;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.permissions.PermissionDefault;
import org.kingdoms.abstraction.processor.AbstractKingdomsProcess;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.building.CommandBuilding;
import org.kingdoms.constants.land.KingdomBlock;
import org.kingdoms.constants.land.KingdomBuildingHandler;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.SimpleContextualMessageSender;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.managers.land.KingdomBuildingManager;
import org.kingdoms.managers.land.block.KingdomsBlockBreakContext;
import org.kingdoms.managers.land.block.KingdomsBlockContext;
import org.kingdoms.utils.KingdomsBukkitExtensions;
import org.kingdoms.utils.display.visualizer.StructureVisualizer;
import org.kingdoms.utils.internal.functional.Fn;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/kingdoms/commands/general/building/CommandBuildingRemove;", "Lorg/kingdoms/commands/KingdomsCommand;", "parent", "Lorg/kingdoms/commands/KingdomsParentCommand;", "<init>", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "Companion", "core"})
public final class CommandBuildingRemove
extends KingdomsCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public CommandBuildingRemove(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("remove", parent, PermissionDefault.TRUE);
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        return Companion.remove(context);
    }

    @JvmStatic
    @NotNull
    public static final CommandResult remove(@NotNull SimpleContextualMessageSender context) {
        return Companion.remove(context);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lorg/kingdoms/commands/general/building/CommandBuildingRemove$Companion;", "", "<init>", "()V", "remove", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/locale/SimpleContextualMessageSender;", "core"})
    @SourceDebugExtension(value={"SMAP\nCommandBuildingCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandBuildingCommands.kt\norg/kingdoms/commands/general/building/CommandBuildingRemove$Companion\n+ 2 KingdomsBukkitExtensions.kt\norg/kingdoms/utils/KingdomsBukkitExtensions\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n33#2:95\n1#3:96\n*S KotlinDebug\n*F\n+ 1 CommandBuildingCommands.kt\norg/kingdoms/commands/general/building/CommandBuildingRemove$Companion\n*L\n30#1:95\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CommandResult remove(@NotNull SimpleContextualMessageSender context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            KingdomBlock kingdomBlock = CommandBuilding.Companion.getKingdomBlock(context);
            if (kingdomBlock == null) {
                return CommandResult.FAILED;
            }
            KingdomBlock kingdomBlock2 = kingdomBlock;
            Player player = context.senderAsPlayer();
            Block block = kingdomBlock2.getOrigin().getBlock();
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
            Block bukkitBlock = block;
            BlockBreakEvent blockBreakEvent = new BlockBreakEvent(bukkitBlock, player);
            Object object = KingdomsBukkitExtensions.INSTANCE;
            Intrinsics.checkNotNull((Object)player);
            OfflinePlayer $this$asKingdomPlayer$iv = (OfflinePlayer)player;
            boolean $i$f$asKingdomPlayer = false;
            KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer($this$asKingdomPlayer$iv);
            Intrinsics.checkNotNullExpressionValue((Object)kingdomPlayer, (String)"getKingdomPlayer(...)");
            Object $this$remove_u24lambda_u240 = object = new KingdomsBlockBreakContext<KingdomBlock>(blockBreakEvent, kingdomBlock2, kingdomPlayer);
            boolean bl = false;
            ((Map)((AbstractKingdomsProcess)$this$remove_u24lambda_u240).getMetadata()).put(KingdomsBlockContext.DefaultMetadatas.CONFIRMATION, true);
            Object kingdomBlockContext = object;
            KingdomBuildingHandler<?> kingdomBuildingHandler = kingdomBlock2.getKingdomBlockHandler();
            Object t = Fn.cast(kingdomBlockContext);
            Intrinsics.checkNotNullExpressionValue(t, (String)"cast(...)");
            Messenger messenger = kingdomBuildingHandler.onBreak((KingdomsBlockBreakContext)t);
            if (messenger != null) {
                Messenger it = messenger;
                boolean bl2 = false;
                kingdomBlockContext.fail(it);
            }
            if (!((AbstractKingdomsProcess)kingdomBlockContext).isSuccessful()) {
                CommandSender commandSender = context.getMessageReceiver();
                Intrinsics.checkNotNullExpressionValue((Object)commandSender, (String)"getMessageReceiver(...)");
                kingdomBlockContext.sendMessages(commandSender);
                return CommandResult.FAILED;
            }
            kingdomBlockContext.finalizeProcess();
            Namespace namespace = KingdomBuildingManager.PREVIEW_NS;
            Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"PREVIEW_NS");
            StructureVisualizer.Companion.stop(player, namespace);
            return CommandResult.SUCCESS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

