/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.building;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.building.CommandBuildingPreview;
import org.kingdoms.commands.general.building.CommandBuildingRemove;
import org.kingdoms.commands.general.building.CommandBuildingRepair;
import org.kingdoms.commands.general.building.CommandBuildingUpgrade;
import org.kingdoms.constants.land.KingdomBlock;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.SimpleContextualMessageSender;
import org.kingdoms.managers.land.KingdomBuildingManager;
import org.kingdoms.server.location.BlockLocation3;
import org.kingdoms.utils.display.visualizer.StructureVisualizer;
import org.kingdoms.utils.display.visualizer.Visualizer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/kingdoms/commands/general/building/CommandBuilding;", "Lorg/kingdoms/commands/KingdomsParentCommand;", "<init>", "()V", "Companion", "core"})
public final class CommandBuilding
extends KingdomsParentCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public CommandBuilding() {
        super("building");
        new CommandBuildingPreview(this);
        new CommandBuildingRemove(this);
        new CommandBuildingUpgrade(this);
        new CommandBuildingRepair(this);
    }

    @JvmStatic
    @Nullable
    public static final KingdomBlock getKingdomBlock(@NotNull SimpleContextualMessageSender context) {
        return Companion.getKingdomBlock(context);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lorg/kingdoms/commands/general/building/CommandBuilding$Companion;", "", "<init>", "()V", "getKingdomBlock", "Lorg/kingdoms/constants/land/KingdomBlock;", "context", "Lorg/kingdoms/locale/SimpleContextualMessageSender;", "core"})
    @SourceDebugExtension(value={"SMAP\nCommandBuilding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandBuilding.kt\norg/kingdoms/commands/general/building/CommandBuilding$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n1#2:49\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final KingdomBlock getKingdomBlock(@NotNull SimpleContextualMessageSender context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            CommandSender commandSender = context.getMessageReceiver();
            Intrinsics.checkNotNull((Object)commandSender, (String)"null cannot be cast to non-null type org.bukkit.entity.Player");
            Player player = (Player)commandSender;
            Namespace namespace = KingdomBuildingManager.PREVIEW_NS;
            Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"PREVIEW_NS");
            Visualizer preview = StructureVisualizer.Companion.get(player, namespace);
            if (preview == null) {
                context.sendError(StructureVisualizer.LAST_PREVIEW.isInCooldown(player.getUniqueId(), KingdomBuildingManager.PREVIEW_NS) ? KingdomsLang.COMMAND_BUILDING_EXPIRED : KingdomsLang.COMMAND_BUILDING_NO_TARGET, new Object[0]);
                return null;
            }
            Object object = preview.getMetadata().get(KingdomBuildingManager.ORIGIN_NS);
            BlockLocation3 blockLocation3 = object instanceof BlockLocation3 ? (BlockLocation3)object : null;
            if (blockLocation3 == null) {
                Companion $this$getKingdomBlock_u24lambda_u240 = this;
                boolean bl = false;
                context.sendError(KingdomsLang.COMMAND_BUILDING_EXPIRED, new Object[0]);
                return null;
            }
            BlockLocation3 exactClick = blockLocation3;
            Land land = SimpleLocation.of(exactClick).toSimpleChunkLocation().getLand();
            if (land == null) {
                Companion $this$getKingdomBlock_u24lambda_u241 = this;
                boolean bl = false;
                context.sendError(KingdomsLang.COMMAND_BUILDING_EXPIRED, new Object[0]);
                return null;
            }
            Land land2 = land;
            KingdomBlock kingdomBlock = land2.getKingdomBlocks().get(exactClick.toVector());
            if (kingdomBlock == null) {
                Companion $this$getKingdomBlock_u24lambda_u242 = this;
                boolean bl = false;
                context.sendError(KingdomsLang.COMMAND_BUILDING_EXPIRED, new Object[0]);
                return null;
            }
            KingdomBlock kingdomBlock2 = kingdomBlock;
            return kingdomBlock2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

