/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.book;

import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.managers.book.BookManager;
import org.kingdoms.managers.book.BookSession;
import org.kingdoms.utils.nms.XBook;

public class CommandBookPreview
extends KingdomsCommand {
    public CommandBookPreview(KingdomsParentCommand parent) {
        super("preview", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        BookSession editingChapter = BookManager.getSession(player);
        if (editingChapter == null) {
            context.sendError(KingdomsLang.COMMAND_BOOK_PREVIEW_NOTHING_TO_PREVIEW, new Object[0]);
            return CommandResult.FAILED;
        }
        ItemStack book = player.getInventory().getItem(editingChapter.getSlot());
        BookMeta meta = (BookMeta)book.getItemMeta();
        book = XBook.getBook((List<String>)meta.getPages(), player, meta.getTitle(), false, false);
        XBook.openBook(book, player);
        context.sendMessage((Messenger)KingdomsLang.COMMAND_BOOK_PREVIEW_PREVIEWING, "chapter", meta.getTitle());
        return CommandResult.SUCCESS;
    }
}

