/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.book;

import java.util.List;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.book.CommandBookDiscard;
import org.kingdoms.commands.general.book.CommandBookEdit;
import org.kingdoms.commands.general.book.CommandBookOpen;
import org.kingdoms.commands.general.book.CommandBookPreview;
import org.kingdoms.commands.general.book.CommandBookRemove;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.BookChapter;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.locale.KingdomsLang;

public class CommandBook
extends KingdomsParentCommand {
    public CommandBook() {
        super("book", true);
        if (this.isDisabled()) {
            return;
        }
        new CommandBookOpen(this);
        new CommandBookEdit(this);
        new CommandBookPreview(this);
        new CommandBookDiscard(this);
        new CommandBookRemove(this);
    }

    protected static BookChapter initialCheckup(CommandContext context, KingdomsLang usage, boolean permission) {
        return CommandBook.initialCheckup(context, usage, 1, permission);
    }

    protected static BookChapter initialCheckup(CommandContext context, KingdomsLang usage, int args, boolean permission) {
        if (context.assertPlayer()) {
            return null;
        }
        if (!context.assertArgs(args)) {
            context.sendError(usage, new Object[0]);
            return null;
        }
        KingdomPlayer kp = context.getKingdomPlayer();
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            context.sendError(KingdomsLang.NO_KINGDOM_DEFAULT, new Object[0]);
            return null;
        }
        if (permission && !kp.isAdmin() && !kp.hasPermission(StandardKingdomPermission.LORE)) {
            context.sendError(KingdomsLang.COMMAND_BOOK_PERMISSION, new Object[0]);
            return null;
        }
        BookChapter chapter = kingdom.getBook().get(context.arg(0));
        if (chapter == null) {
            context.sendError(KingdomsLang.COMMAND_BOOK_CHAPTER_NOT_FOUND, "chapter", context.arg(0));
            return null;
        }
        return chapter;
    }

    protected static List<String> tabCompleteBooks(CommandTabContext context) {
        if (context.isPlayer() && context.isAtArg(0)) {
            Kingdom kingdom = context.getKingdom();
            if (kingdom == null) {
                return CommandBook.tabComplete(KingdomsLang.NO_KINGDOM_DEFAULT.parse(new Object[0]));
            }
            return CommandBook.tabComplete(kingdom.getBook().keySet());
        }
        return CommandBook.emptyTab();
    }
}

